/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.common.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.management.annotations.ManagedResource;
import org.eclipse.cosmos.me.management.common.info.ComposedCapabilityInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationConsumerInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedRelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedResourceInfo
extends MBeanInfo {
    private ManagedAttributeInfo resourceIdAttribute = null;
    private ManagedRelationInfo[] relations;
    private ManagedNotificationConsumerInfo[] consumers;
    private String targetNamespace = "";
    private boolean hasMetrics = false;
    private boolean advertised = false;
    private boolean hasEventConsumers = false;
    private String advertisementConsumer = "";
    private Annotation[] annotations;
    private Class resourceClass;
    private String[] capabilities;
    ComposedCapabilityInfo[] composedCapabilities;
    private HashMap<String, String> namespaceList = new HashMap();
    private HashMap<Class, HashMap<String, HandlerDescriptor>> capabilityMethodMap = new HashMap();

    public HashMap<Class, HashMap<String, HandlerDescriptor>> getCapabilityMethodMap() {
        return this.capabilityMethodMap;
    }

    public ManagedResourceInfo(Class resourceClass, String name, String description, String targetNamespace, String[] capabilities, ManagedAttributeInfo[] properties, MBeanConstructorInfo[] constructors, ManagedOperationInfo[] operations, ManagedRelationInfo[] relations, ManagedNotificationInfo[] notifications, ManagedNotificationConsumerInfo[] consumers, ComposedCapabilityInfo[] composedCapabilities, Annotation[] annotations) throws IllegalArgumentException {
        super(name, description, properties, constructors, operations, notifications);
        String namespace;
        int n;
        int n2;
        Object[] objectArray;
        int namespaceCount = 0;
        this.targetNamespace = targetNamespace;
        this.annotations = annotations;
        this.resourceClass = resourceClass;
        this.capabilities = capabilities;
        this.namespaceList.put(targetNamespace, "dyn");
        if (properties != null) {
            objectArray = properties;
            n2 = properties.length;
            n = 0;
            while (n < n2) {
                Object property = objectArray[n];
                if (((ManagedAttributeInfo)property).isResourceID() && ((MBeanAttributeInfo)property).isReadable() && !((MBeanAttributeInfo)property).isWritable()) {
                    this.resourceIdAttribute = property;
                } else if (((ManagedAttributeInfo)property).isMetric()) {
                    this.hasMetrics = true;
                }
                namespace = ((ManagedAttributeInfo)property).getNamespace();
                if (!"".equals(namespace) && this.namespaceList.get(namespace) == null) {
                    this.namespaceList.put(namespace, "dyn_" + namespaceCount++);
                }
                ++n;
            }
        }
        if (operations != null) {
            objectArray = operations;
            n2 = operations.length;
            n = 0;
            while (n < n2) {
                Object operation = objectArray[n];
                if (((ManagedOperationInfo)operation).isEventConsumer()) {
                    this.hasEventConsumers = true;
                }
                if (!"".equals(namespace = ((ManagedOperationInfo)operation).getNamespace()) && this.namespaceList.get(namespace) == null) {
                    this.namespaceList.put(namespace, "dyn_" + namespaceCount++);
                }
                ++n;
            }
        }
        this.relations = relations;
        this.consumers = consumers;
        objectArray = annotations;
        n2 = annotations.length;
        n = 0;
        while (n < n2) {
            Object annotation = objectArray[n];
            if (annotation instanceof ManagedResource) {
                this.advertised = ((ManagedResource)annotation).advertise();
                this.advertisementConsumer = ((ManagedResource)annotation).advertisementConsumer();
                break;
            }
            ++n;
        }
        this.composedCapabilities = composedCapabilities;
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaceList.containsKey(namespace);
    }

    public String[] getNamespaces() {
        return this.namespaceList.keySet().toArray(new String[0]);
    }

    public String getPrefixForNamespace(String namespace) {
        if ("".equals(namespace)) {
            return "dyn";
        }
        return this.namespaceList.get(namespace);
    }

    public ManagedAttributeInfo getResourceIdField() {
        return this.resourceIdAttribute;
    }

    public boolean resourceLifetimeSupport() {
        return false;
    }

    public boolean hasMetrics() {
        return this.hasMetrics;
    }

    public boolean isAdvertised() {
        return this.advertised;
    }

    public boolean hasEventConsumers() {
        return this.hasEventConsumers;
    }

    public String getAdvertisementConsumer() {
        return this.advertisementConsumer;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getResourceName() {
        return this.getClassName();
    }

    public ManagedRelationInfo[] getRelations() {
        return this.relations;
    }

    public ManagedNotificationConsumerInfo[] getConsumers() {
        return this.consumers;
    }

    public ComposedCapabilityInfo[] getComposedCapabilities() {
        return this.composedCapabilities;
    }

    private String getMethodName(String actionName) {
        return String.valueOf(Character.toLowerCase(actionName.charAt(0))) + actionName.substring(1);
    }

    public Class getResourceClass() {
        return this.resourceClass;
    }

    public String[] getCapabilities() {
        return this.capabilities;
    }

    public class HandlerDescriptor {
        Method method;
        QName inputName;
        QName outputName;

        public HandlerDescriptor(Method method, QName inputName, QName outputName) {
            this.method = method;
            this.inputName = inputName;
            this.outputName = outputName;
        }
    }
}

