/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.internal.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JavaLoggingSAXHandler
extends DefaultHandler {
    SAXParserFactory spfactory = SAXParserFactory.newInstance();
    private Stack stack = null;
    private StringBuffer charactersBuffer = null;
    private EventFactory eventFactory = null;
    private List commonBaseEvents = null;
    private CommonBaseEvent event = null;
    private ExtendedDataElement exceptionEDE = null;
    private ExtendedDataElement frameEDE = null;

    public JavaLoggingSAXHandler(EventFactory evtFactory) {
        this.eventFactory = evtFactory;
        this.commonBaseEvents = new ArrayList();
        this.stack = new Stack();
        this.charactersBuffer = new StringBuffer();
        this.spfactory.setValidating(false);
    }

    public void startDocument() throws SAXException {
        this.commonBaseEvents.clear();
        this.stack.clear();
        this.clearBuffer(this.charactersBuffer);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.push(qName);
        String key = this.stackItems();
        if (key.equals("record")) {
            this.event = this.eventFactory.createCommonBaseEvent();
            this.event.init();
            this.event.setGlobalInstanceId(Guid.generate());
            this.event.setSourceComponentId(this.getSourceComponentId());
            this.event.setSituation(this.getSituation());
            this.commonBaseEvents.add(this.event);
        } else if (key.equals("record.exception")) {
            this.exceptionEDE = this.createNoValueEDE("stackTrace");
            this.event.addExtendedDataElement(this.exceptionEDE);
        } else if (key.equals("record.exception.frame")) {
            this.frameEDE = this.createNoValueEDE(qName);
            this.exceptionEDE.addChild(this.frameEDE);
        }
    }

    private MsgDataElement getMsgDataElement() {
        MsgDataElement msdDataElement = null;
        msdDataElement = this.event.getMsgDataElement();
        if (msdDataElement == null) {
            msdDataElement = this.eventFactory.createMsgDataElement();
            msdDataElement.init();
            msdDataElement.setMsgId("Unknown");
            msdDataElement.setMsgIdType("Unknown");
            this.event.setMsgDataElement(msdDataElement);
        }
        return msdDataElement;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String key = this.stackItems();
        String val = null;
        val = this.charactersBuffer.toString().trim();
        if (val.length() != 0) {
            if (key.equals("record.logger")) {
                this.event.addExtendedDataElement(this.createStringEDE("loggerName", val));
            } else if (key.equals("record.message")) {
                if (val.length() > 1024) {
                    this.event.setMsg(val.substring(0, 1024));
                    this.event.addExtendedDataElement(this.createStringEDE("message", val));
                } else {
                    this.event.setMsg(val);
                }
            } else if (key.equals("record.millis")) {
                this.event.setCreationTimeAsLong(Long.parseLong(val));
            } else if (key.equals("record.sequence")) {
                this.event.addExtendedDataElement(this.createIntEDE("sequenceNumber", Integer.parseInt(val)));
            } else if (key.equals("record.level")) {
                ExtendedDataElement level = this.createNoValueEDE(qName);
                level.addChild(this.createStringEDE("name", val));
                try {
                    level.addChild(this.createIntEDE("value", Level.parse(val).intValue()));
                }
                catch (Exception exception) {}
                this.event.addExtendedDataElement(level);
            } else if (key.equals("record.thread")) {
                this.event.getSourceComponentId().setThreadId(val);
                this.event.addExtendedDataElement(this.createStringEDE("threadID", val));
            } else if (key.equals("record.method")) {
                this.event.getSourceComponentId().setSubComponent(val);
                this.event.addExtendedDataElement(this.createStringEDE("sourceMethodName", val));
            } else if (key.equals("record.class")) {
                this.event.getSourceComponentId().setComponent(val);
                this.event.addExtendedDataElement(this.createStringEDE("sourceClassName", val));
            } else if (key.equals("record.key")) {
                MsgDataElement msdDataElement = this.getMsgDataElement();
                msdDataElement.setMsgCatalogId(val);
            } else if (key.equals("record.catalog")) {
                MsgDataElement msdDataElement = this.getMsgDataElement();
                msdDataElement.setMsgCatalog(val);
                msdDataElement.setMsgCatalogType("Java");
            } else if (key.equals("record.param")) {
                MsgDataElement msdDataElement = this.getMsgDataElement();
                MsgCatalogToken msgCatalogTok = this.eventFactory.createMsgCatalogToken();
                msgCatalogTok.init();
                msgCatalogTok.setValue(val);
                msdDataElement.getMsgCatalogTokens().add((Object)msgCatalogTok);
            } else if (key.equals("record.exception.message")) {
                this.exceptionEDE.addChild(this.createStringEDE(qName, val));
            } else if (key.equals("record.exception.frame.class")) {
                this.frameEDE.addChild(this.createStringEDE(qName, val));
            } else if (key.equals("record.exception.frame.method")) {
                this.frameEDE.addChild(this.createStringEDE(qName, val));
            } else if (key.equals("record.exception.frame.line")) {
                this.frameEDE.addChild(this.createStringEDE(qName, val));
            }
        }
        this.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charactersBuffer.append(new String(ch, start, length));
    }

    public void parse(String xmlString) throws IOException, SAXException, ParserConfigurationException {
        SAXParser saxParser = this.spfactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        StringReader characterStream = new StringReader(xmlString);
        InputSource XmlSource = new InputSource(characterStream);
        xmlReader.parse(XmlSource);
    }

    public void endDocument() throws SAXException {
    }

    public int size() {
        return this.commonBaseEvents.size();
    }

    public CommonBaseEvent[] getCommonBaseEvents() {
        if (this.commonBaseEvents != null && !this.commonBaseEvents.isEmpty()) {
            return this.commonBaseEvents.toArray(new CommonBaseEvent[this.commonBaseEvents.size()]);
        }
        return null;
    }

    protected ExtendedDataElement createStringEDE(String name, String value) {
        ExtendedDataElement extendedDataElement = this.eventFactory.createExtendedDataElement();
        extendedDataElement.setName(name);
        int valuesLength = 0;
        if (value != null && (valuesLength = value.trim().length()) > 1024) {
            extendedDataElement.setTypeAsInt(16);
            ArrayList<String> valuesParts = new ArrayList<String>();
            int counter = 0;
            while (counter < valuesLength) {
                valuesParts.add(value.substring(counter, Math.min(counter + 1024, valuesLength)));
                counter += 1024;
            }
            extendedDataElement.setValues(valuesParts.toArray(new String[valuesParts.size()]));
        } else {
            extendedDataElement.setTypeAsInt(7);
            extendedDataElement.setValues(new String[]{value});
        }
        return extendedDataElement;
    }

    protected ExtendedDataElement createIntEDE(String name, int value) {
        ExtendedDataElement extendedDataElement = this.eventFactory.createExtendedDataElement();
        extendedDataElement.setName(name);
        extendedDataElement.setValuesAsInt(value);
        return extendedDataElement;
    }

    protected ExtendedDataElement createNoValueEDE(String name) {
        ExtendedDataElement extendedDataElement = this.eventFactory.createExtendedDataElement();
        extendedDataElement.setName(name);
        extendedDataElement.setType("noValue");
        return extendedDataElement;
    }

    protected Situation getSituation() {
        ReportSituation reportSituation = this.eventFactory.createReportSituation();
        reportSituation.setReasoningScope("INTERNAL");
        reportSituation.setReportCategory("LOG");
        Situation cbeSituation = this.eventFactory.createSituation();
        cbeSituation.setCategoryName("ReportSituation");
        cbeSituation.setSituationType((SituationType)reportSituation);
        return cbeSituation;
    }

    protected ComponentIdentification getSourceComponentId() {
        ComponentIdentification sourceComponentId = this.eventFactory.createComponentIdentification();
        sourceComponentId.init();
        sourceComponentId.setComponent("Unknown");
        sourceComponentId.setComponentIdType("Application");
        sourceComponentId.setComponentType("Logging_Application");
        sourceComponentId.setExecutionEnvironment("Java");
        sourceComponentId.setSubComponent("Unknown");
        sourceComponentId.setLocation(ParserConstants.LOCALHOST_ID);
        sourceComponentId.setLocationType(ParserConstants.LOCALHOST_ID_FORMAT);
        return sourceComponentId;
    }

    private void push(String key) {
        this.stack.push(key);
    }

    private String pop() {
        this.clearBuffer(this.charactersBuffer);
        return (String)this.stack.pop();
    }

    private String stackItems() {
        Iterator ite = this.stack.iterator();
        String result = "";
        boolean isStart = true;
        while (ite.hasNext()) {
            if (isStart) {
                result = (String)ite.next();
                if (result.equalsIgnoreCase("log")) {
                    result = "";
                    continue;
                }
                isStart = false;
                continue;
            }
            result = String.valueOf(result) + "." + (String)ite.next();
        }
        return result;
    }

    private StringBuffer clearBuffer(StringBuffer stringBuffer) {
        try {
            if (stringBuffer == null) {
                return new StringBuffer();
            }
            stringBuffer.setLength(0);
            return stringBuffer;
        }
        catch (Exception exception) {
            return new StringBuffer();
        }
    }
}

