/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.ws.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.dc.broker.ws.client.DataManager;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Groups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerClient {
    private EndpointReference epr;
    private ServiceClient sender;

    public BrokerClient(String eprstr) throws AxisFault {
        this.epr = new EndpointReference(eprstr);
        Options options = new Options();
        options.setTo(this.epr);
        options.setTransportInProtocol("http");
        this.sender = new ServiceClient();
        this.sender.setOptions(options);
    }

    public OMElement registerGroup(Group group) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement registerGroupRequest = fac.createOMElement("registerGroup", omNs);
        registerGroupRequest.addChild((OMNode)group.toOM());
        OMElement result = this.sender.sendReceive(registerGroupRequest);
        return result;
    }

    public OMElement deregisterGroup(String hostname, String groupName) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement deregisterGroupRequest = fac.createOMElement("deregisterGroup", omNs);
        OMElement hostxml = fac.createOMElement("host", omNs, (OMContainer)deregisterGroupRequest);
        OMElement groupNamexml = fac.createOMElement("name", omNs, (OMContainer)deregisterGroupRequest);
        fac.createOMText((OMContainer)hostxml, hostname);
        fac.createOMText((OMContainer)groupNamexml, groupName);
        OMElement result = this.sender.sendReceive(deregisterGroupRequest);
        return result;
    }

    public List<DataManager> getDataManagers() throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement deregisterGroupRequest = fac.createOMElement("getAllGroups", omNs);
        OMElement result = this.sender.sendReceive(deregisterGroupRequest);
        Groups groups = Groups.getGroups(result);
        ArrayList<DataManager> dataManagers = new ArrayList<DataManager>();
        for (Group group : groups.getGroups()) {
            DataManager dm = new DataManager(group);
            dataManagers.add(dm);
        }
        return dataManagers;
    }

    public DataManager getDataManager(String hostname, String groupName) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement deregisterGroupRequest = fac.createOMElement("getGroup", omNs);
        OMElement hostxml = fac.createOMElement("host", omNs, (OMContainer)deregisterGroupRequest);
        OMElement groupNamexml = fac.createOMElement("name", omNs, (OMContainer)deregisterGroupRequest);
        fac.createOMText((OMContainer)hostxml, hostname);
        fac.createOMText((OMContainer)groupNamexml, groupName);
        OMElement result = this.sender.sendReceive(deregisterGroupRequest);
        if (result != null) {
            return new DataManager(Group.getGroup(result));
        }
        return null;
    }

    public List<DataManager> getDataManagerByNamespace(String ns) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement getDataManagerByNamespaceRequest = fac.createOMElement("getGroupsByNamespace", omNs);
        OMElement hostxml = fac.createOMElement("namespace", omNs, (OMContainer)getDataManagerByNamespaceRequest);
        fac.createOMText((OMContainer)hostxml, ns);
        OMElement result = this.sender.sendReceive(getDataManagerByNamespaceRequest);
        Groups groups = Groups.getGroups(result);
        ArrayList<DataManager> dataManagers = new ArrayList<DataManager>();
        for (Group group : groups.getGroups()) {
            DataManager dm = new DataManager(group);
            dataManagers.add(dm);
        }
        return dataManagers;
    }
}

