/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.sun50.fastxpath.operations;

import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.objects.XBoolean;
import com.sun.org.apache.xpath.internal.objects.XBooleanStatic;
import com.sun.org.apache.xpath.internal.objects.XNumber;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.operations.Operation;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FXPObject;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.EExpression;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.EExpressionFactory;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.objects.EXObject;

public class EOperation
extends EExpression {
    private Operation op;
    protected IExpression eLeft;
    protected IExpression eRight;

    public IExpression instance(Expression expression) {
        return new EOperation((Operation)expression);
    }

    public EOperation(Operation operation) {
        this.op = operation;
    }

    public Expression getExpression() {
        return this.op.getExpression();
    }

    public Expression getLeftOperand() {
        return this.op.getLeftOperand();
    }

    public Expression getRightOperand() {
        return this.op.getRightOperand();
    }

    public XObject operate(XObject xObject, XObject xObject2) throws TransformerException {
        return this.op.operate(xObject, xObject2);
    }

    public void setExpression(Expression expression) {
        this.op.setExpression(expression);
    }

    public void setLeftRight(Expression expression, Expression expression2) {
        this.op.setLeftRight(expression, expression2);
    }

    public XObject operate(EXObject eXObject, EXObject eXObject2) throws TransformerException {
        return this.op.operate(eXObject.getXo(), eXObject2.getXo());
    }

    public Object[] execute(FastXPathContext fastXPathContext) throws TransformerException, ExpressionEvaluationException {
        Object[] objectArray = this.getELeft().execute(fastXPathContext);
        Object[] objectArray2 = this.getERight().execute(fastXPathContext);
        if (objectArray.length == 0) {
            objectArray = new Object[]{XBooleanStatic.S_FALSE};
        }
        if (objectArray2.length == 0) {
            objectArray2 = new Object[]{XBooleanStatic.S_FALSE};
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < objectArray2.length; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                Object object = objectArray2[i];
                Object object2 = objectArray[j];
                if (object2 instanceof FXPObject) {
                    object2 = ((FXPObject)object2).getVal();
                }
                if (object instanceof FXPObject) {
                    object = ((FXPObject)object).getVal();
                }
                if (object instanceof XBoolean) {
                    object2 = this.turnToXBoolean(object2);
                }
                if (object2 instanceof XBoolean) {
                    object = this.turnToXBoolean(object);
                }
                arrayList.add(new Object[]{this.operate(new EXObject(object2.toString()), new EXObject(object.toString()))});
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray3 = (Object[])iterator.next();
            if (objectArray3.length == 0 || !this.turnToXBoolean(objectArray3[0]).bool()) {
                iterator.remove();
                continue;
            }
            return objectArray3;
        }
        return new Object[0];
    }

    public void compile(ICompilerContext iCompilerContext) throws CodeGenerationError {
        iCompilerContext.in(this);
        this.getELeft().compile(iCompilerContext);
        iCompilerContext.append(this.getOpAsString());
        iCompilerContext.append("( ");
        this.getERight().compile(iCompilerContext);
        iCompilerContext.append(")");
        iCompilerContext.out();
    }

    protected String getOpAsString() {
        return null;
    }

    private XBooleanStatic turnToXBoolean(Object object) {
        XBooleanStatic xBooleanStatic;
        if (object instanceof String) {
            xBooleanStatic = new XBooleanStatic(((String)object).length() > 0);
        } else if (object instanceof Boolean) {
            xBooleanStatic = new XBooleanStatic((boolean)((Boolean)object));
        } else if (object instanceof XNumber) {
            xBooleanStatic = new XBooleanStatic(((XNumber)object).num() != 0.0);
        } else if (object instanceof XObject) {
            try {
                xBooleanStatic = new XBooleanStatic(((XObject)object).bool());
            }
            catch (TransformerException transformerException) {
                xBooleanStatic = new XBooleanStatic(object != null);
            }
        } else {
            xBooleanStatic = new XBooleanStatic(object != null);
        }
        return xBooleanStatic;
    }

    public void printGraph(int n) {
        IExpression iExpression;
        super.printGraph(n);
        String string = this.indent(n);
        IExpression iExpression2 = this.getELeft();
        if (iExpression2 != null) {
            System.out.println(string + "LEFT:");
            iExpression2.printGraph(n + 1);
        }
        if ((iExpression = this.getERight()) != null) {
            System.out.println(string + "RIGHT:");
            iExpression.printGraph(n + 1);
        }
    }

    public void linkParent(IExpression iExpression) {
        IExpression iExpression2;
        super.linkParent(iExpression);
        IExpression iExpression3 = this.getELeft();
        if (iExpression3 != null) {
            iExpression3.linkParent(iExpression);
        }
        if ((iExpression2 = this.getERight()) != null) {
            iExpression2.linkParent(iExpression);
        }
    }

    public IExpression getELeft() {
        if (this.eLeft == null) {
            this.eLeft = EExpressionFactory.INSTANCE.createEExprNode(this.op.getLeftOperand());
        }
        return this.eLeft;
    }

    public IExpression getERight() {
        if (this.eRight == null) {
            this.eRight = EExpressionFactory.INSTANCE.createEExprNode(this.op.getRightOperand());
        }
        return this.eRight;
    }

    protected boolean leftSideSatisfies(Object[] objectArray) {
        Object object;
        return objectArray.length != 0 && ((object = objectArray[0]) instanceof XBoolean && ((XBoolean)object).bool() || !(object instanceof XBoolean));
    }
}

