/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.SimpleResource;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.impl.SimpleIdentity;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.OpenMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.schema.OpenPropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.impl.SimpleResourcePropertiesSchema;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.eclipse.cosmos.me.management.common.BindingStructureHelper;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;
import org.eclipse.cosmos.me.management.common.util.SequentialResourceIDFactory;
import org.eclipse.cosmos.me.management.provisional.wsdm.DynamicBindingCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.impl.IdentityImpl;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicAdvertisementCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicMetadataDescriptor;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicResourcePropertyCollection;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDLSource;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBindingFactory;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDMBinding
extends SimpleResource
implements WsResource {
    private Object resource;
    private String resourceId;
    private Document wsdl;
    private ResourcePropertyCollection _properties = null;
    private static Messages _MESSAGES = MessagesFactory.get(SimpleResource.class);
    private WSDMInfo wsdmInfo;

    public static URI getLocalAddress(String contextPath, String port) throws UnknownHostException {
        String ip = InetAddress.getLocalHost().getHostAddress();
        InetAddress.getLocalHost().getCanonicalHostName();
        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);
        if (contextPath.charAt(0) != '/') {
            address.append('/');
        }
        address.append(contextPath);
        return URI.create(address.toString());
    }

    Object getResource() {
        return this.resource;
    }

    public String getNamespace() {
        return this.wsdmInfo.getTargetNamespace();
    }

    public WSDMBinding(WSDMInfo wsdmInfo, Object resource) {
        this.wsdmInfo = wsdmInfo;
        this.resource = resource;
        String resourceId = null;
        ManagedAttributeInfo resourceIdAttribute = wsdmInfo.getResourceIdField();
        if (resource instanceof ManagementProxy) {
            resource = ((ManagementProxy)resource).getProxiedObject();
        }
        if (resourceIdAttribute != null) {
            try {
                String name = resourceIdAttribute.getName();
                name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
                Method getId = resource.getClass().getMethod("get" + name, new Class[0]);
                Object idObject = getId.invoke(resource, new Object[0]);
                resourceId = idObject.toString();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            resourceId = SequentialResourceIDFactory.getResourceID();
        }
        this.resourceId = resourceId;
        try {
            URI uri = WSDMBinding.getLocalAddress(String.valueOf(WSDMBindingFactory.getDefault().getContextPath()) + "/services/" + wsdmInfo.getResourceName(), WSDMBindingFactory.getDefault().getPort());
            this.setEndpointReference(new EndpointReference(uri));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        QName name = WsaConstants.DEFAULT_RESOURCE_ID_QNAME;
        this.getEndpointReference().addParameter(name, (Object)resourceId);
        ManagedAttributeInfo resourceIdField = wsdmInfo.getResourceIdField();
        if (resourceIdField == null) {
            SimpleIdentity identityCap = new SimpleIdentity();
            identityCap.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Identity");
            this.addCapability((Capability)identityCap);
        } else {
            try {
                Object value = resourceIdField.getGetter().invoke(resource, null);
                IdentityImpl identityCap = new IdentityImpl(value.toString());
                identityCap.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Identity");
                this.addCapability((Capability)identityCap);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public Element invoke(Element soapBody) {
        return super.invoke(soapBody);
    }

    protected ResourcePropertyCollection createPropertyCollection() {
        return new DynamicResourcePropertyCollection();
    }

    public void initialize() throws SoapFault {
        WSDLSource metaData = new WSDLSource(this.wsdmInfo, this.resource);
        metaData.setCapabilityURI("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata");
        metaData.setResource((Resource)this);
        metaData.setMessageHandlers(this.wsdmInfo.createMessageHandlers(WSDLSource.class));
        this.addCapability((Capability)metaData);
        int dynIndex = 0;
        try {
            ManagedResourceInfo info = this.wsdmInfo.getInfo();
            String[] stringArray = this.wsdmInfo.getCapabilityURIs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                Class capClass = this.wsdmInfo.getCapabilityClass(uri);
                Object cap = null;
                try {
                    Object impl = null;
                    impl = capClass == this.wsdmInfo.getInfo().getResourceClass() ? this.resource : BindingStructureHelper.instantiateCapability((String)uri, (Class)capClass);
                    cap = impl instanceof Capability ? (Capability)impl : (impl instanceof WSDMDelegator ? ((WSDMDelegator)impl).getDelegateCapability() : new DynamicCapability());
                    if (cap instanceof DynamicBindingCapability) {
                        ((DynamicBindingCapability)cap).initializeBindingInfo(this.wsdmInfo, uri, "dyn" + dynIndex++);
                    }
                    cap.setCapabilityURI(uri);
                    cap.setResource((Resource)this);
                    cap.setMessageHandlers(this.wsdmInfo.createMessageHandlers(capClass));
                    this.addCapability((Capability)cap);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("No Capability Implementation for " + uri);
                }
                ++n2;
            }
            if (this.wsdmInfo.getCapabilityClass("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer") != null) {
                NotificationProducer notificationProducer = (NotificationProducer)this.getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
                ManagedNotificationInfo[] managedNotificationInfoArray = (ManagedNotificationInfo[])info.getNotifications();
                int n3 = managedNotificationInfoArray.length;
                n = 0;
                while (n < n3) {
                    ManagedNotificationInfo notification = managedNotificationInfoArray[n];
                    if (!notification.isSpecNotification()) {
                        String namespace = notification.getNamespace();
                        if ("".equals(namespace)) {
                            namespace = info.getTargetNamespace();
                        }
                        notification.getNotifTypes();
                        notification.getName();
                        if (notificationProducer.getTopicNamespace(namespace) == null) {
                            notificationProducer.addTopicNamespace(namespace);
                        }
                        notificationProducer.addTopic(new QName(namespace, notification.getName()));
                    }
                    ++n;
                }
            }
            if (info.isAdvertised()) {
                WSDMBindingFactory.getDefault();
                EndpointReference epr = WSDMBindingFactory.getAdvertisementTarget(info.getAdvertisementConsumer());
                DynamicAdvertisementCapability advertisement = (DynamicAdvertisementCapability)this.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Advertisement");
                advertisement.setInitialConsumerEpr(epr);
            }
            this._properties = this.createPropertyCollection();
            WSDLSource wsdlSource = new WSDLSource(this.wsdmInfo, this.resource);
            wsdlSource.setEnvironment(this.getEnvironment());
            this.wsdl = wsdlSource.getWSDLDocument();
            ResourcePropertiesSchema schema = this.createPropertiesSchema(this.wsdl);
            this._properties.setSchema(schema);
            MetadataDescriptor metadata = this.createMetadataDescriptor(this.wsdl);
            this._properties.setMetadata(metadata);
            super.initialize();
            this._properties.applyMetadata();
            this._properties.validateMetadata();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new SoapFault(t);
        }
    }

    public void shutdown() throws SoapFault {
        System.out.println("Unexpected call to shutdown");
        throw new UnsupportedOperationException();
    }

    public ResourcePropertyCollection getPropertyCollection() {
        return this._properties;
    }

    protected MetadataDescriptor createMetadataDescriptor(Document wsdl) {
        String path;
        Element portTypeXML = WsdlUtils.getPortType((Node)wsdl, (QName)this.getWsdlPortType());
        String rmdName = XmlUtils.getAttribute((Element)portTypeXML, (QName)WsrmdConstants.DESCRIPTOR_ATTR_QNAME);
        String rmdPath = XmlUtils.getAttribute((Element)portTypeXML, (QName)WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME);
        if (rmdName == null && rmdPath == null && !this.wsdmInfo.hasMetrics()) {
            return OpenMetadataDescriptor.getInstance();
        }
        if (this.wsdmInfo.hasMetrics()) {
            DynamicMetadataDescriptor descriptor = new DynamicMetadataDescriptor(this.wsdmInfo.getInfo(), wsdl.getDocumentElement());
            return descriptor;
        }
        if ((rmdName == null || rmdPath == null) && rmdName != rmdPath) {
            throw new RuntimeException(_MESSAGES.get("IncompleteMetadataAttributes"));
        }
        Environment env = this.getEnvironment();
        Document rmdDoc = env.getDocument(path = env.createRelativePath(this.getWsdlPath(), rmdPath));
        Element descriptorXML = WsrmdUtils.getMetadataDescriptor((Document)rmdDoc, (String)rmdName);
        if (descriptorXML == null) {
            Object[] filler = new Object[]{rmdPath, rmdName};
            throw new RuntimeException(_MESSAGES.get("DescriptorNotFound", filler));
        }
        return new SimpleMetadataDescriptor(descriptorXML);
    }

    protected ResourcePropertiesSchema createPropertiesSchema(Document wsdl) {
        QName wsrpName = WsrpUtils.getPropertiesName((Node)wsdl, (QName)this.getWsdlPortType());
        Element wsrpDoc = WsdlUtils.getElementDeclaration((Node)wsdl, (QName)wsrpName);
        if (wsrpDoc == null) {
            Object[] filler = new Object[]{this.getContextPath(), this.getWsdlPath()};
            this.getLog().warning(_MESSAGES.get("NoWSRPDocument", filler));
            return OpenPropertiesSchema.getInstance();
        }
        return new SimpleResourcePropertiesSchema(wsrpName, wsrpDoc);
    }

    public Document getWsdlDocument() {
        return this.wsdl;
    }
}

