/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.OperationalStatus;
import org.apache.muse.ws.dm.muws.Participant;
import org.apache.muse.ws.dm.muws.RelationshipType;
import org.apache.muse.ws.dm.muws.Relationships;
import org.apache.muse.ws.dm.muws.events.Component;
import org.apache.muse.ws.dm.muws.events.ComponentAddress;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.dm.muws.events.Situation;
import org.apache.muse.ws.dm.muws.events.WefFactory;
import org.apache.muse.ws.dm.muws.events.impl.SimpleWefFactory;
import org.apache.muse.ws.dm.muws.impl.SimpleParticipant;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationshipType;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.properties.get.GetCapability;
import org.eclipse.cosmos.me.management.annotations.CreateManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedEvent;
import org.eclipse.cosmos.me.management.annotations.ManagedEventSituation;
import org.eclipse.cosmos.me.management.annotations.ManagedEventSource;
import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.api.EventSituation;
import org.eclipse.cosmos.me.management.api.EventSource;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.BindingStructureHelper;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.StatusChangeListener;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBinding;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBindingUtil;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMNotificationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMRelationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.util.SchemaHelper;
import org.eclipse.cosmos.me.management.provisional.wsdm.util.WSDMHelperRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WSDMBindingFactory
implements Binding,
WSDMHelperRegistry {
    private static WefFactory wefFactory = new SimpleWefFactory();
    public static final WSDMAttributeInfo[] EMPTY_ATTR_INFO_ARRAY = new WSDMAttributeInfo[0];
    public static final WSDMOperationInfo[] EMPTY_OPER_INFO_ARRAY = new WSDMOperationInfo[0];
    public static final WSDMRelationInfo[] EMPTY_RELATION_INFO_ARRAY = new WSDMRelationInfo[0];
    public static final WSDMNotificationInfo[] EMPTY_NOTIFICATION_INFO_ARRAY = new WSDMNotificationInfo[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    protected static WeakHashMap<Object, WsResource> boundObjectMap = new WeakHashMap();
    protected static WeakHashMap<Class, WSDMInfo> boundClassMap = new WeakHashMap();
    protected static HashMap<String, EndpointReference> advertisementMap = new HashMap();
    protected static HashMap<String, Object> capabilityFactoryMap = new HashMap();
    protected ResourceRouter _router;
    protected ResourceManager _resourceManager;
    protected ContributionManager _manager;
    protected static String contextPath;
    protected static String port;
    protected StatusChangeListener.STATUS status = StatusChangeListener.STATUS.PARTIALLY_AVAILABLE;
    protected static WSDMBindingFactory _default;

    static {
        port = System.getProperty("org.osgi.service.http.port", "80");
        contextPath = "cosmos";
    }

    protected static WSDMBindingFactory createInstance() {
        return null;
    }

    public static WSDMBindingFactory getDefault() {
        if (_default == null) {
            _default = WSDMBindingFactory.createInstance();
        }
        return _default;
    }

    public void setResourceRouter(ResourceRouter router) {
        this._router = router;
        WSDMBindingFactory.loadAdvertisementTargets();
    }

    public void setResourceManager(ResourceManager manager) {
        this._resourceManager = manager;
    }

    public void setContributionManager(ContributionManager manager) {
        WSDMBindingFactory._default._manager = manager;
    }

    public static void register(Object resource) throws Exception {
    }

    public void postProcessRegistration(WSDMBinding binding) {
    }

    public void bindContribution(Object contribution, boolean register) {
        try {
            WSDMBinding binding = null;
            if (register) {
                ManagedResourceInfo info = BindingStructureHelper.getResourceInfo((Object)contribution);
                ManagedAttributeInfo[] cfr_ignored_0 = (ManagedAttributeInfo[])info.getAttributes();
                ManagedOperationInfo[] cfr_ignored_1 = (ManagedOperationInfo[])info.getOperations();
                ManagedNotificationInfo[] cfr_ignored_2 = (ManagedNotificationInfo[])info.getNotifications();
                info.getRelations();
                info.getResourceIdField();
                WSDMInfo wsdmInfo = new WSDMInfo(info, contribution);
                wsdmInfo.compileCapabilties(WSDMBindingFactory._default._router.getEnvironment(), info);
                binding = new WSDMBinding(wsdmInfo, contribution);
                binding.setLog(WSDMBindingFactory._default._router.getLog());
                binding.setEnvironment(WSDMBindingFactory._default._router.getEnvironment());
                binding.setResourceManager(WSDMBindingFactory._default._resourceManager);
                binding.setContextPath("/" + info.getResourceName());
                binding.setWsdlPath("");
                binding.setWsdlPortType(new QName(info.getTargetNamespace(), String.valueOf(info.getResourceName()) + "PortType"));
                binding.initialize();
                WSDMBindingFactory._default._resourceManager.addResource(binding.getEndpointReference(), (Resource)binding);
                boundObjectMap.put(contribution, binding);
                if (contribution instanceof ManagementProxy) {
                    boundObjectMap.put(((ManagementProxy)contribution).getProxiedObject(), binding);
                }
                this.postProcessRegistration(binding);
            } else {
                ManagedResourceInfo info = BindingStructureHelper.getResourceInfo((Object)contribution);
                WSDMInfo wsdmInfo = new WSDMInfo(info, contribution);
                wsdmInfo.compileCapabilties(WSDMBindingFactory._default._router.getEnvironment(), info);
                binding = new WSDMBinding(wsdmInfo, contribution);
                binding.setLog(WSDMBindingFactory._default._router.getLog());
                binding.setEnvironment(WSDMBindingFactory._default._router.getEnvironment());
                binding.setResourceManager(WSDMBindingFactory._default._resourceManager);
                binding.setContextPath("/" + info.getResourceName());
                binding.setWsdlPath("");
                binding.setWsdlPortType(new QName(info.getTargetNamespace(), String.valueOf(info.getResourceName()) + "PortType"));
                binding.initialize();
                WSDMBindingFactory._default._resourceManager.addResource(binding.getEndpointReference(), (Resource)binding);
                boundObjectMap.put(contribution, binding);
                if (contribution instanceof ManagementProxy) {
                    boundObjectMap.put(((ManagementProxy)contribution).getProxiedObject(), binding);
                }
            }
            if (binding != null) {
                System.out.println(binding.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unbindContribution(Object contribution) {
        boundObjectMap.remove(contribution);
        if (contribution instanceof ManagementProxy) {
            boundObjectMap.remove(((ManagementProxy)contribution).getProxiedObject());
        }
    }

    public void addRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
        System.out.println("Adding relationship");
        WsResource resource = boundObjectMap.get(object);
        if (resource == null || !(resource instanceof WSDMBinding)) {
            return;
        }
        try {
            Relationships relCap = (Relationships)resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
            if (relCap == null) {
                return;
            }
            WsResource targetResource = boundObjectMap.get(args[0]);
            if (targetResource == null) {
                System.out.println("cannot locate relationship target");
                return;
            }
            String name = "contains";
            String relationType = "container";
            String[] role = new String[]{"container", "contained"};
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                ManagedRelation managedRelation;
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof ManagedRelation) {
                    managedRelation = (ManagedRelation)annotation;
                    if (!"".equals(managedRelation.name())) {
                        name = managedRelation.name();
                    }
                    role = managedRelation.roles();
                    relationType = managedRelation.type();
                } else if (annotation instanceof CreateManagedRelation) {
                    managedRelation = (CreateManagedRelation)annotation;
                    if (!"".equals(managedRelation.name())) {
                        name = managedRelation.name();
                    }
                    role = managedRelation.roles();
                    relationType = managedRelation.type();
                }
                ++n2;
            }
            Participant[] participants = new Participant[2];
            QName[] typeNames = new QName[]{new QName(((WSDMBinding)resource).getNamespace(), relationType, "tns")};
            SimpleRelationshipType type = new SimpleRelationshipType(typeNames);
            participants[0] = new SimpleParticipant(resource, role[0]);
            participants[1] = new SimpleParticipant(targetResource, role[1]);
            relCap.addRelationship(name, (RelationshipType)type, participants);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void raiseEvent(Object object, Method method, Object[] args, Object ret, Annotation[] annotations) {
        WsResource binding = boundObjectMap.get(object);
        if (binding == null || !(binding instanceof WSDMBinding)) {
            return;
        }
        Capability wsnCapability = binding.getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        if (wsnCapability != null && wsnCapability instanceof NotificationProducer) {
            ManagedEvent event = null;
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof ManagedEvent) {
                    event = (ManagedEvent)annotation;
                    break;
                }
                ++n2;
            }
            String namespace = event.namespace();
            String format = event.format();
            if ("".equals(namespace)) {
                Annotation[] annotationArray2 = annotations;
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation annotation = annotationArray2[n4];
                    if (annotation instanceof ManagedResourceCapability) {
                        namespace = ((ManagedResourceCapability)annotation).namespace();
                        break;
                    }
                    ++n4;
                }
                if ("".equals(namespace)) {
                    namespace = ((WSDMBinding)binding).getNamespace();
                }
            }
            QName topicName = new QName(namespace, event.topic(), "dyn");
            try {
                Element payload = XmlUtils.createElement((QName)topicName, (Object)"value");
                if (ret != null) {
                    if (ret instanceof Element) {
                        payload = (Element)ret;
                    } else {
                        Serializer ser = SerializerRegistry.getInstance().getSerializer(ret.getClass());
                        if (ser != null) {
                            payload = ser.toXML(ret, topicName);
                        }
                    }
                }
                if ("wef".equals(format)) {
                    ManagementEvent wefEvent = wefFactory.createEvent();
                    wefEvent.setEventID(event.topic());
                    if (payload != null) {
                        wefEvent.addExtendedElement(payload);
                    }
                    Component reporter = wefFactory.createComponent(binding.getEndpointReference().toXML());
                    reporter.setName(new QName(((WSDMBinding)binding).getNamespace(), "reporter", "dyn"));
                    wefEvent.setReporter(reporter);
                    Date currentTime = new Date(System.currentTimeMillis());
                    wefEvent.setReportTime(currentTime);
                    Annotation[][] parmAnnotationList = method.getParameterAnnotations();
                    int currentParmIndex = 0;
                    EventSource sourceHelper = null;
                    EventSituation situationHelper = null;
                    Annotation[][] annotationArray3 = parmAnnotationList;
                    int n5 = parmAnnotationList.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Annotation[] parmAnnotations = annotationArray3[n6];
                        if (parmAnnotations.length > 0) {
                            Annotation[] annotationArray4 = parmAnnotations;
                            int n7 = parmAnnotations.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                Object arg;
                                Annotation annotation = annotationArray4[n8];
                                if (annotation instanceof ManagedEventSource && (arg = args[currentParmIndex]) instanceof EventSource) {
                                    sourceHelper = (EventSource)arg;
                                }
                                if (annotation instanceof ManagedEventSituation && (arg = args[currentParmIndex]) instanceof EventSituation) {
                                    situationHelper = (EventSituation)arg;
                                }
                                ++n8;
                            }
                        }
                        ++currentParmIndex;
                        ++n6;
                    }
                    Component source = wefFactory.createComponent();
                    if (sourceHelper != null) {
                        source.setName(sourceHelper.getName());
                        Object managedSource = sourceHelper.getManagedObject();
                        if (managedSource != null) {
                            WsResource sourceBinding = boundObjectMap.get(object);
                            ComponentAddress sourceAddress = null;
                            sourceAddress = sourceBinding != null ? wefFactory.createComponentAddress(sourceBinding.getEndpointReference().toXML()) : wefFactory.createComponentAddress();
                            source.setAddress(sourceAddress);
                            Properties props = sourceHelper.getSourceProperties();
                            for (Object key : props.keySet()) {
                                if (!(key instanceof QName)) continue;
                                source.addExtendedElement((QName)key, props.get(key));
                            }
                        }
                    } else {
                        source.setName(new QName("bogus", "source"));
                        ComponentAddress sourceAddress = wefFactory.createComponentAddress();
                        source.setAddress(sourceAddress);
                    }
                    wefEvent.setSource(source);
                    Situation situation = wefFactory.createSituation();
                    if (situationHelper != null) {
                        situation.setCategoryType(situationHelper.getCategoryType());
                        situation.setMessage(situationHelper.getMessage());
                        situation.setSeverity(situationHelper.getSeverity());
                        situation.setPriority(situationHelper.getPriority());
                        situation.setSuccessDisposition(situationHelper.getSuccessDisposition());
                    } else {
                        situation.setCategoryType(new QName("bugus", "category"));
                        situation.setMessage("Hello there");
                        situation.setPriority((short)10);
                        situation.setSeverity((short)1);
                        situation.setSituationTime(currentTime);
                    }
                    wefEvent.setSituation(situation);
                    payload = wefEvent.toXML();
                }
                ((NotificationProducer)wsnCapability).publish(topicName, payload);
            }
            catch (SoapFault e) {
                e.printStackTrace();
            }
        }
    }

    public void removeRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
        System.out.println("Removing relationship");
        WsResource resource = boundObjectMap.get(object);
        if (resource == null || !(resource instanceof WSDMBinding)) {
            return;
        }
        try {
            WsResource[] relationships;
            Relationships relCap = (Relationships)resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
            if (relCap == null) {
                return;
            }
            WsResource targetResource = boundObjectMap.get(args[0]);
            if (targetResource == null) {
                System.out.println("cannot locate relationship target");
                return;
            }
            String name = "contains";
            String relationType = "container";
            String[] role = new String[]{"container", "contained"};
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof ManagedRelation) {
                    ManagedRelation managedRelation = (ManagedRelation)annotation;
                    if (!"".equals(managedRelation.name())) {
                        name = managedRelation.name();
                    }
                    role = managedRelation.roles();
                    relationType = managedRelation.type();
                }
                ++n2;
            }
            Participant[] participants = new Participant[2];
            QName[] typeNames = new QName[]{new QName(((WSDMBinding)resource).getNamespace(), relationType, "tns")};
            new SimpleRelationshipType(typeNames);
            participants[0] = new SimpleParticipant(resource, role[0]);
            participants[1] = new SimpleParticipant(targetResource, role[1]);
            WsResource[] wsResourceArray = relationships = relCap.getRelationship();
            int n3 = relationships.length;
            int n4 = 0;
            while (n4 < n3) {
                WsResource relationship = wsResourceArray[n4];
                System.out.println(relationship);
                GetCapability getCap = (GetCapability)relationship.getCapability("http://docs.oasis-open.org/wsrf/rpw-2/Get");
                if (getCap != null) {
                    Element[] typeMatch;
                    Element[] testParts = getCap.getResourceProperty(MuwsConstants.PARTICIPANT_QNAME);
                    Element[] testType = getCap.getResourceProperty(MuwsConstants.TYPE_QNAME);
                    Element[] testName = getCap.getResourceProperty(MuwsConstants.NAME_QNAME);
                    String testNameValue = testName[0].getTextContent();
                    if (name.equals(testNameValue) && (typeMatch = XmlUtils.getElements((Node)testType[0], (QName)typeNames[0])).length != 0) {
                        SimpleParticipant tp1 = new SimpleParticipant(testParts[0]);
                        SimpleParticipant tp2 = new SimpleParticipant(testParts[1]);
                        if (this.isSameParticipant(participants[0], (Participant)tp1) && this.isSameParticipant(participants[1], (Participant)tp2)) {
                            System.out.println("Got a match!!!");
                        }
                    }
                }
                ++n4;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean isSameParticipant(Participant p1, Participant p2) {
        if (!p1.getManageabilityReference().equals((Object)p2.getManageabilityReference())) {
            return false;
        }
        if (!p1.getResourceId().equals(p2.getResourceId())) {
            return false;
        }
        return p1.getRole().equals(p2.getRole());
    }

    public void statusChanged(Object object, StatusChangeListener.STATUS newStatus) {
        WsResource binding = boundObjectMap.get(object);
        if (binding != null) {
            Capability capability = binding.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus");
            if (capability != null && capability instanceof OperationalStatus) {
                if (newStatus == StatusChangeListener.STATUS.AVAILABLE || newStatus == StatusChangeListener.STATUS.PARTIALLY_AVAILABLE || newStatus == StatusChangeListener.STATUS.UNAVAILABLE) {
                    // empty if block
                }
                try {
                    ((OperationalStatus)capability).setOperationalStatus("Unknown");
                }
                catch (BaseFault baseFault) {}
            }
        } else if (object == this) {
            this.status = newStatus;
        }
    }

    protected static void loadAdvertisementTargets() {
    }

    public static EndpointReference getAdvertisementTarget(String key) {
        String propValue;
        EndpointReference ref = advertisementMap.get(key);
        if (ref == null && (propValue = System.getProperty(key)) != null) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(propValue.getBytes());
                Document doc = XmlUtils.createDocument((InputStream)stream);
                ref = new EndpointReference(doc.getDocumentElement());
                System.out.println("Ref is " + ref);
                advertisementMap.put(key, ref);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (ref == null) {
            ref = advertisementMap.get("default");
        }
        return ref;
    }

    public StatusChangeListener.STATUS getStatus() {
        return this.status;
    }

    public Object getBindingForObject(Object boundObject) {
        return boundObjectMap.get(boundObject);
    }

    public void registerSchemaHelper(Class type, SchemaHelper helper) {
        WSDMBindingUtil.registerSchemaHelper(type, helper);
    }

    public void registerSerializer(Class type, Serializer serializer) {
        SerializerRegistry.getInstance().registerSerializer(type, serializer);
    }

    public void registerCapabilityFactory(String uri, Class factory) {
        BindingStructureHelper.setCapabilityFactory((String)uri, (Class)factory);
    }

    public String getBindingName() {
        return "WSDM";
    }

    public Document getWSDLDocument(Object resource) {
        WSDMBinding binding = (WSDMBinding)((Object)this.getBindingForObject(resource));
        if (binding != null) {
            return binding.getWsdlDocument();
        }
        return null;
    }

    public String getContextPath() {
        return contextPath;
    }

    public String getPort() {
        return port;
    }

    public void setContextPath(String contextPathString) {
        contextPath = contextPathString;
    }

    public void setPort(String portString) {
        port = portString;
    }
}

