/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.adapter.outputters;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.commons.FileLogger;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.parsers.adapter.outputters.LogImportOutputter;

public class CBEXMLLogImportOutputter
extends LogImportOutputter {
    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null || this.outLogger == null) {
            return msgs;
        }
        if (msgs instanceof MessageString[]) {
            MessageString[] msgStrObjs = (MessageString[])msgs;
            String[] msgStrs = new String[msgStrObjs.length];
            int k = 0;
            while (k < msgStrObjs.length) {
                if (msgStrObjs[k] != null) {
                    msgStrs[k] = msgStrObjs[k].getValue();
                }
                ++k;
            }
            return this.processCBEXMLStrings(msgStrs);
        }
        return this.processCBEXMLStrings((String[])msgs);
    }

    private Object[] processCBEXMLStrings(String[] events) {
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                if (events[i] != null) {
                    try {
                        this.outLogger.trace((Object)events[i]);
                        this.incrementItemsProcessedCount();
                    }
                    catch (Exception ioe) {
                        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                        String loggerName = "unknown";
                        if (this.outLogger instanceof Logger) {
                            loggerName = ((Logger)this.outLogger).getName();
                        } else if (this.outLogger instanceof FileLogger) {
                            loggerName = ((FileLogger)this.outLogger).getName();
                        }
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), loggerName, ioe.getMessage()});
                        event.setSeverity((short)60);
                        this.log(event);
                    }
                }
                ++i;
            }
            return events;
        }
        return null;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof MessageString[]) && !(msgs instanceof String[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of Message Strings or Strings");
        }
        return msgs;
    }
}

