/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.ws.persistence.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Groups;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Service;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Services;
import org.eclipse.cosmos.dc.broker.ws.persistence.BrokerDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerDatabaseImpl
implements BrokerDatabase {
    private static File databaseDir = null;
    private static File databaseFile = null;
    private static Groups groups = null;
    private static Object writeLock = new Object();
    private static BrokerDatabaseImpl instance = new BrokerDatabaseImpl();

    public static BrokerDatabaseImpl getInstance() {
        return instance;
    }

    private BrokerDatabaseImpl() {
    }

    @Override
    public void init(Map<String, Object> initMap) {
        String dbdir = initMap.get("dbdir").toString();
        this.setDatabaseDir(new File(dbdir));
    }

    private void setDatabaseDir(File dbdir) {
        if (!dbdir.exists()) {
            dbdir.mkdir();
        }
        databaseDir = dbdir;
    }

    @Override
    public Groups getAllGroups() {
        if (groups == null) {
            this.loadxml();
        }
        return groups;
    }

    @Override
    public Groups getGroupsByNamespace(String ns) {
        if (groups == null) {
            this.loadxml();
        }
        Groups result = new Groups();
        ArrayList<Group> groupList = new ArrayList<Group>();
        result.setGroups(groupList);
        block0: for (Group group : groups.getGroups()) {
            List<Service> serviceList;
            Services services = group.getServices();
            if (services == null || (serviceList = services.getServices()) == null) continue;
            for (Service service : serviceList) {
                if (!service.getNamespace().equals(ns)) continue;
                groupList.add(group);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Group getGroup(String hostname, String groupName) {
        if (groups == null) {
            this.loadxml();
        }
        for (Group group : groups.getGroups()) {
            if (!group.getHost().equals(hostname) || !group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(Group newgroup) {
        if (groups == null) {
            this.loadxml();
        }
        Object object = writeLock;
        synchronized (object) {
            String host = newgroup.getHost();
            String name = newgroup.getName();
            List<Group> groupList = groups.getGroups();
            for (Group group : groupList) {
                if (!group.getHost().equals(host) || !group.getName().equals(name)) continue;
                System.out.println("Service has already been registered at this broker.  No new brokers are registered. ");
                return;
            }
            groupList.add(newgroup);
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(String hostname, String groupName) {
        if (groups == null) {
            this.loadxml();
        }
        boolean exist = false;
        Object object = writeLock;
        synchronized (object) {
            List<Group> groupList = groups.getGroups();
            for (Group group : groupList) {
                if (!group.getHost().equals(hostname) || !group.getName().equals(groupName)) continue;
                groupList.remove(group);
                exist = true;
                break;
            }
            this.save();
        }
    }

    private void loadxml() {
        if (databaseFile == null && !(databaseFile = new File(databaseDir, "brokerdb.xml")).exists()) {
            try {
                databaseFile.createNewFile();
            }
            catch (IOException iOException) {}
            groups = new Groups();
            this.save();
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(databaseFile);
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement docRoot = builder.getDocumentElement();
            groups = Groups.getGroups(docRoot);
        }
        catch (Exception exception) {}
    }

    private synchronized void save() {
        try {
            FileWriter fw = new FileWriter(databaseFile);
            OMElement om = groups.toOM();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fw);
            om.serialize(writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

