/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.example.mdr.registration.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleFederatingCMDBUtil {
    private static final int RECORDS = 0;
    private static final int ADDITIONAL_RECORDS = 1;
    private static final int INSTANCE_IDS = 2;

    public static IQueryServiceElementCollection handleInstanceIdConstraint(SampleFederatingCMDB federatingCMDB, IQueryServiceElementCollection context, IInstanceId[] instanceId, boolean isItem) {
        Map<String, Map<String, IGraphElement>> graphElements = isItem ? federatingCMDB.retrieveItemsMap() : federatingCMDB.retrieveRelationshipsMap();
        List<IGraphElement> currentResult = context.isStartingContext() ? null : SampleFederatingCMDBUtil.createGraphElementList(context.getElements());
        int i = 0;
        while (i < instanceId.length) {
            if (currentResult == null) {
                currentResult = SampleFederatingCMDBUtil.findMatchedGraphElements(instanceId[i], graphElements);
            } else {
                ArrayList<IGraphElement> newList = new ArrayList<IGraphElement>();
                int j = 0;
                int currentResultCount = currentResult.size();
                while (j < currentResultCount) {
                    IInstanceId[] instanceIds = currentResult.get(j).getInstanceIds();
                    if (SampleFederatingCMDBUtil.contains(instanceId[i], instanceIds)) {
                        newList.add(currentResult.get(j));
                    }
                    ++j;
                }
                currentResult = newList;
            }
            if (currentResult.isEmpty()) break;
            ++i;
        }
        INodes newContext = isItem ? QueryOutputArtifactFactory.getInstance().createNodes(context.getId()) : QueryOutputArtifactFactory.getInstance().createEdges(context.getId());
        int i2 = 0;
        int itemCount = currentResult.size();
        while (i2 < itemCount) {
            if (isItem) {
                newContext.addItem((IItem)currentResult.get(i2));
            } else {
                ((IEdges)newContext).addRelationship((IRelationship)currentResult.get(i2));
            }
            ++i2;
        }
        return newContext;
    }

    private static boolean contains(IInstanceId instanceId, IInstanceId[] instanceIds) {
        String mdrId = instanceId.getMdrId().toString();
        String localId = instanceId.getLocalId().toString();
        int i = 0;
        while (i < instanceIds.length) {
            if (SampleFederatingCMDBUtil.matched(mdrId, instanceIds[i].getMdrId().toString()) && SampleFederatingCMDBUtil.matched(localId, instanceIds[i].getLocalId().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean matched(String str1, String str2) {
        if ("*".equals(str1)) {
            return true;
        }
        return str1.equals(str2);
    }

    public static boolean isEqual(Object[] array1, Object[] array2, boolean matchAny) {
        if (!matchAny && array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            boolean found = false;
            int j = 0;
            while (j < array2.length) {
                if (array1[i].equals(array2[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!matchAny && !found) {
                return false;
            }
            if (matchAny && found) {
                return true;
            }
            ++i;
        }
        return !matchAny;
    }

    public static List<IGraphElement> createGraphElementList(IGraphElement[] elements) {
        ArrayList<IGraphElement> list = new ArrayList<IGraphElement>();
        int i = 0;
        while (i < elements.length) {
            list.add(elements[i]);
            ++i;
        }
        return list;
    }

    public static List<IGraphElement> findMutualSet(List<IGraphElement> list1, List<IGraphElement> list2, boolean isItem) {
        ArrayList<IGraphElement> result = new ArrayList<IGraphElement>();
        int i = 0;
        int list1Count = list1.size();
        while (i < list1Count) {
            IGraphElement graphElement1 = list1.get(i);
            int j = 0;
            int list2Count = list2.size();
            while (j < list2Count) {
                IGraphElement graphElement2 = list2.get(j);
                if (graphElement1.equals(graphElement2)) {
                    result.add(SampleFederatingCMDBUtil.clone(graphElement1, graphElement2, isItem));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static boolean isEqual(IGraphElement graphElement1, IGraphElement graphElement2) {
        return SampleFederatingCMDBUtil.isEqual(graphElement1.getRecords(), graphElement2.getRecords(), false) && SampleFederatingCMDBUtil.isEqual(graphElement1.getAdditionalRecordTypes(), graphElement2.getAdditionalRecordTypes(), false);
    }

    public static IGraphElement clone(IGraphElement graphElement1, IGraphElement graphElement2, boolean isItem) {
        IItem graphElement = isItem ? QueryOutputArtifactFactory.getInstance().createItem() : QueryOutputArtifactFactory.getInstance().createRelationship();
        SampleFederatingCMDBUtil.addAttribute((IGraphElement)graphElement, 0, graphElement1.getRecords());
        SampleFederatingCMDBUtil.addAttribute((IGraphElement)graphElement, 1, graphElement1.getAdditionalRecordTypes());
        IInstanceId[] instanceIds1 = graphElement1.getInstanceIds();
        IInstanceId[] instanceIds2 = graphElement2.getInstanceIds();
        ArrayList<IInstanceId> finalInstanceIdList = new ArrayList<IInstanceId>();
        int i = 0;
        while (i < instanceIds1.length) {
            finalInstanceIdList.add(instanceIds1[i]);
            ++i;
        }
        i = 0;
        while (i < instanceIds2.length) {
            if (!finalInstanceIdList.contains(instanceIds2[i])) {
                finalInstanceIdList.add(instanceIds2[i]);
            }
            ++i;
        }
        SampleFederatingCMDBUtil.addAttribute((IGraphElement)graphElement, 2, finalInstanceIdList.toArray(new IInstanceId[finalInstanceIdList.size()]));
        return graphElement;
    }

    public static void addAttribute(IGraphElement graphElement, int attributeType, Object[] attributes) {
        if (attributes == null) {
            return;
        }
        int i = 0;
        while (i < attributes.length) {
            switch (attributeType) {
                case 0: {
                    graphElement.addRecord((IRecord)attributes[i]);
                    break;
                }
                case 1: {
                    graphElement.addAdditionalRecordType((IAdditionalRecordType)attributes[i]);
                    break;
                }
                case 2: {
                    graphElement.addInstanceId((IInstanceId)attributes[i]);
                }
            }
            ++i;
        }
    }

    public static List<IGraphElement> findMatchedGraphElements(IInstanceId instanceId, Map<String, Map<String, IGraphElement>> graphElements) {
        String mdrId = instanceId.getMdrId().toString();
        String localId = instanceId.getLocalId().toString();
        Map<String, IGraphElement>[] matchingMDRs = SampleFederatingCMDBUtil.findMatchingMDRs(mdrId, graphElements);
        ArrayList<IGraphElement> result = new ArrayList<IGraphElement>();
        int j = 0;
        while (j < matchingMDRs.length) {
            result.addAll(SampleFederatingCMDBUtil.findMatchingGraphElements(matchingMDRs[j], localId));
            ++j;
        }
        return result;
    }

    public static Map<String, IGraphElement>[] findMatchingMDRs(String mdrId, Map<String, Map<String, IGraphElement>> graphElements) {
        Map[] mapArray;
        if ("*".equals(mdrId)) {
            return graphElements.values().toArray(new Map[graphElements.size()]);
        }
        Map<String, IGraphElement> matchedMDRs = graphElements.get(mdrId);
        if (matchedMDRs == null) {
            mapArray = new Map[]{};
        } else {
            Map[] mapArray2 = new Map[1];
            mapArray = mapArray2;
            mapArray2[0] = matchedMDRs;
        }
        return mapArray;
    }

    public static List<IGraphElement> findMatchingGraphElements(Map<String, IGraphElement> matchedMDRs, String localId) {
        ArrayList<IGraphElement> matchedGraphElements = new ArrayList<IGraphElement>();
        if ("*".equals(localId)) {
            matchedGraphElements.addAll(matchedMDRs.values());
        } else {
            IGraphElement element = matchedMDRs.get(localId);
            if (element != null) {
                matchedGraphElements.add(element);
            }
        }
        return matchedGraphElements;
    }
}

