/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mdr.registration.client;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.mdr.client.MdrClient;
import org.eclipse.cosmos.dc.mdr.registration.common.IFederatingCMDB;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.EndPointReferenceSerializer;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.MDRIdentifierSerializer;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.SelectiveRegistrationInputSerializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FederatingCMDBClient
extends MdrClient {
    public FederatingCMDBClient(EndpointReference destination) {
        super(destination);
    }

    public Element register(Element registrationRequest) throws DataManagerException {
        return this.invokeRemoteOperation(registrationRequest, IFederatingCMDB.REGISTRATION_OP_QNAME, IFederatingCMDB.REGISTRATION_REQUEST_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/register");
    }

    public Element register(EndpointReference[] mdrEPRs) throws DataManagerException {
        return this.invokeRemoteOperation(EndPointReferenceSerializer.getInstance().toXML(this.constructIdentifiers(mdrEPRs)), IFederatingCMDB.REGISTER_MDR_ENTRIES_OP_QNAME, IFederatingCMDB.REGISTER_MDR_ENTRIES_MDR_ID_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/registerMDREntries");
    }

    public Element register(EndpointReference[] mdrEPRs, Element query) throws DataManagerException {
        return this.invokeRemoteOperation(SelectiveRegistrationInputSerializer.getInstance().toXML(this.constructIdentifiers(mdrEPRs), query), IFederatingCMDB.REGISTER_SELECTIVE_MDR_ENTRIES_OP_QNAME, IFederatingCMDB.REGISTER_SELECTIVE_MDR_ENTRIES_REQUEST_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/registerSelectiveMDREntries");
    }

    public Element register(String managementDominEPR) throws DataManagerException {
        Element argument = XmlUtils.createElement((QName)new QName("managementDomain"));
        argument.setTextContent(managementDominEPR);
        return this.invokeRemoteOperation(argument, IFederatingCMDB.REGISTER_ALL_OP_QNAME, IFederatingCMDB.REGISTER_ALL_MGT_DOMAIN_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/registerAll");
    }

    public Element deregister(Element deregistrationRequest) throws DataManagerException {
        return this.invokeRemoteOperation(deregistrationRequest, IFederatingCMDB.DEREGISTER_OP_QNAME, IFederatingCMDB.DEREGISTER_REQUEST_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/deregister");
    }

    public Element deregister(EndpointReference[] mdrIds) throws DataManagerException {
        return this.invokeRemoteOperation(MDRIdentifierSerializer.getInstance().toXML(mdrIds), IFederatingCMDB.DEREGISTER_MDR_ENTRIES_OP_QNAME, IFederatingCMDB.DEREGISTER_MDR_ENTRIES_MDR_ID_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/deregisterMDREntries");
    }

    public Element deregister(InputStream query) throws DataManagerException {
        try {
            Element queryElement = XmlUtils.getDocumentRoot((Node)DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(query));
            return this.invokeRemoteOperation(queryElement, IFederatingCMDB.DEREGISTER_SELECTIVE_ENTRIES_OP_QNAME, IFederatingCMDB.DEREGISTER_SELECTIVE_ENTRIES_QUERY_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/deregisterSelectiveEntries");
        }
        catch (Exception e) {
            throw new DataManagerException((Throwable)e);
        }
    }

    public Element deregisterAll() throws DataManagerException {
        return this.invokeRemoteOperation(IFederatingCMDB.DEREGISTER_ALL_OP_QNAME, "http://www.eclipse.org/cosmos/federatingCMDBOperation/deregisterAll");
    }

    private EndPointReferenceSerializer.MDRReference[] constructIdentifiers(EndpointReference[] mdrEPRs) {
        EndPointReferenceSerializer.MDRReference[] identifiers = new EndPointReferenceSerializer.MDRReference[mdrEPRs.length];
        int i = 0;
        while (i < mdrEPRs.length) {
            identifiers[i] = new EndPointReferenceSerializer.MDRReference(mdrEPRs[i].getAddress().toString(), mdrEPRs[i].getParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME).getTextContent());
            ++i;
        }
        return identifiers;
    }
}

