/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.query.ws;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;

public abstract class AbstractQueryService {
    protected CMDBfQueryOperation queryOp = new CMDBfQueryOperation(this.getQueryHandlerFactory(), null);

    protected abstract IQueryHandlerFactory getQueryHandlerFactory();

    protected CMDBfQueryOperation getQueryOperation() {
        return this.queryOp;
    }

    public OMElement GraphQuery(OMElement query) throws CMDBfServiceException {
        query.build();
        query.detach();
        OMElement documentElement = null;
        IQueryResult result = null;
        try {
            result = this.queryOp.execute((Reader)new StringReader(query.toString()));
        }
        catch (CMDBfServiceException e) {
            e.printStackTrace();
            throw e;
        }
        InputStream output = QueryOutputTransformer.transform((IQueryResult)result);
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(output);
        }
        catch (XMLStreamException xMLStreamException) {}
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        documentElement = builder.getDocumentElement();
        return documentElement;
    }
}

