/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.capabilities;

import org.eclipse.cosmos.me.management.annotations.ManagedPropertyGetter;
import org.eclipse.cosmos.me.management.annotations.ManagedPropertySetter;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;

@ManagedResourceCapability(namespace="http://docs.oasis-open.org/wsdm/muws/capabilities/Description")
public interface DescriptionCapability {
   	
	@ManagedPropertyGetter(namespace="http://docs.oasis-open.org/wsdm/muws2-2.xsd",property="Caption")
	String[] getCaption(); 

	@ManagedPropertyGetter(namespace="http://docs.oasis-open.org/wsdm/muws2-2.xsd",property="Description")
	String[] getDescription(); 
	
	@ManagedPropertyGetter(namespace="http://docs.oasis-open.org/wsdm/muws2-2.xsd",property="Version")
	String getVersion();
	
	@ManagedPropertySetter(namespace="http://docs.oasis-open.org/wsdm/muws2-2.xsd",property="Caption")
	void setCaption(String[] captions); 
	
	@ManagedPropertySetter(namespace="http://docs.oasis-open.org/wsdm/muws2-2.xsd",property="Description")
	void setDescription(String[] descriptions); 
	
	@ManagedPropertySetter(namespace="http://docs.oasis-open.org/wsdm/muws2-2.xsd",property="Version")
	void setVersion(String version);
	
}
