/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.impl;

import org.apache.muse.core.Capability;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.impl.SimpleOperationalStatus;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.OperationalStatusCapability;

public class OperationalStatusImpl implements OperationalStatusCapability, WSDMDelegator {

	private SimpleOperationalStatus operationalStatus;
	
	@ManagedFrameworkAutowire(name = "$RESOURCE")
	Object resource;
	
	public void setResource(Object resource){
		this.resource = resource;
	}
	
	
	public OperationalStatusImpl(){
		operationalStatus = new SimpleOperationalStatus();
	}

	public Capability getDelegateCapability() {
		return operationalStatus;
	}

	public String getOperationalStatus() {
		return operationalStatus.getOperationalStatus();
	}

	public void setOperationalStatus(String status) {
		operationalStatus.setOperationalStatus(status);
	}
	
	
}
