/*
* Copyright (c) 2005-2008 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/package org.eclipse.cosmos.me.management.provisional.wsdm.faults;

import javax.xml.namespace.QName;

import org.apache.muse.ws.resource.WsrfConstants;
import org.apache.muse.ws.resource.faults.ResourceUnavailableFault;
import org.w3c.dom.Element;

public class DynamicFault extends ResourceUnavailableFault {
	
	Element _detail;

	public DynamicFault(Element element) {
		super(element);
	}

	public DynamicFault(String message, Throwable cause) {
		super(message, cause);
	}

	public DynamicFault(Throwable cause) {
		super(cause);
	}
	
    public QName getName()
    {
    	QName name = super.getName();
        if(super.getName() == null){
        	name = WsrfConstants.RESOURCE_UNAVAILABLE_QNAME;
        }
        return name;
    }
	
    public Element getDetail()
    {
    	if(_detail == null){
    		_detail = super.getDetail();
    	}
    	return _detail;
    }

}
