/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.adv.impl.SimpleAdvertisement;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.impl.TopicFilter;

public class DynamicAdvertisementCapability extends SimpleAdvertisement {
	
	protected EndpointReference initialEpr;
	
	public void setInitialConsumerEpr(EndpointReference epr){
		initialEpr = epr;
	}
	
	protected void subscribeInitialConsumer() throws SoapFault	{
		//
		// pre-existing consumer is optional - other consumers can 
		// still subscribe using WS-N
		//
		if(initialEpr != null){
			NotificationProducer wsn = 
				(NotificationProducer)getResource().getCapability(WsnConstants.PRODUCER_URI);
	
			wsn.subscribe(initialEpr, new TopicFilter(MuwsConstants.ADV_ME_CREATION_TOPIC), null, null);
			wsn.subscribe(initialEpr, new TopicFilter(MuwsConstants.ADV_ME_DESTRUCTION_TOPIC), null, null);
		}
	}

}
