/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

import javax.xml.namespace.QName;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.addressing.soap.SoapUtils;
import org.apache.muse.ws.dm.muws.impl.AbstractManageabilityCapability;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.basefaults.WsbfUtils;
import org.apache.muse.ws.resource.faults.ResourceUnavailableFault;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;
import org.eclipse.cosmos.me.management.provisional.wsdm.DynamicBindingCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMOperation;
import org.eclipse.cosmos.me.management.provisional.wsdm.faults.DynamicFault;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.w3c.dom.Element;

public class DynamicCapability extends AbstractManageabilityCapability implements DynamicBindingCapability {

	private ManagedResourceInfo info;
	private String namespace;
	private Object target;
	private QName[] properties = {};
	private HashMap<QName, Method> getterMap = new HashMap<QName, Method>();
	private HashMap<QName, Method> setterMap = new HashMap<QName, Method>();

    public QName[] getPropertyNames()
    {
        return properties;
    }

    protected void createGettersAndSetters(QName propertyName){}
    
    protected Method getGetter(QName propertyQName)
    {
        return (Method)getterMap.get(propertyQName);
    }

    protected Method getSetter(QName propertyQName)
    {
        return (Method)setterMap.get(propertyQName);
    }
    
	public DynamicCapability(){
		super();
	}

	public void initializeCompleted() throws SoapFault{
		super.initializeCompleted();
		try {
			target = this.getWsResource();
			Class targetClass = target.getClass();
			if(this.getWsResource() instanceof WSDMBinding){
				WSDMBinding binding = (WSDMBinding)this.getWsResource();
				target = binding.getResource();
				targetClass = target.getClass();
				if(target instanceof ManagementProxy){
					Object newTarget = ((ManagementProxy)target).getCapability(namespace);
					if(newTarget != null){
						target = ((ManagementProxy)newTarget).getProxiedObject();
					}else{
						target = ((ManagementProxy)target).getProxiedObject();
					}
				}
			}
		}

		catch (Throwable error) {
			error.printStackTrace();
		}

	}


    public Element[] getProperty(QName propertyQName) throws BaseFault {
		Method method = getterMap.get(propertyQName);
		Object result = invokeMethod(method, null);
		return getPropertyElements(propertyQName, result);
	}
    
    private BaseFault handleError(Throwable error){
		Throwable cause = null;
		if(error instanceof InvocationTargetException){
			cause = ((InvocationTargetException)error).getTargetException();
		}
		
		if(cause == null) cause = error.getCause();

		if (cause != null)
			error = cause;

		BaseFault fault = null; 
        if (error instanceof BaseFault){
            fault = (BaseFault)error;
        } else {
	        	fault = new DynamicFault(error);
	        
			Element trace = XmlUtils.createElement(new QName(namespace, "stacktrace"));
			for(StackTraceElement ste : error.getStackTrace()){
				
				Element se = XmlUtils.createElement(new QName(namespace, "stackframe"));
				String names = ste.getClassName()+ "." + ste.getMethodName();
				se.setAttribute("method", names);
				if(ste.getLineNumber() > 0){
					se.setAttribute("line", Integer.toString(ste.getLineNumber()));
				}else {
					se.setAttribute("line", "not available");
				}
				trace.appendChild(se);
			}
			fault.getDetail().appendChild(trace);
			String message = error.getMessage();
			if(message == null){
				message = error.getClass().getName();
			}
			fault.setReason(message);
        }
		return fault;
    }

    protected Object invokeMethod(Method method, Object[] params)
			throws BaseFault {
		Object result = null;

		try {
//			if(this.getWsResource() instanceof WSDMBinding){
//				WSDMBinding binding = (WSDMBinding)this.getWsResource();
//				target = binding.getResource();
//				targetClass = target.getClass();
//				if(target instanceof ManagementProxy){
//					Method proxyMethod = ((ManagementProxy)target).getProxiedMethod(method);
//					if(proxyMethod == null || proxyMethod == method){
//						target = ((ManagementProxy)target).getProxiedObject();
//					} else {
//						method = proxyMethod;
//					}
//				}
//			}
			result = method.invoke(target, params);
		}

		catch (Throwable error) {
			throw handleError(error);
		}

		return result;
	}


    public Object invokeCustomMethod(Method method, Object[] params)
			throws Throwable {
		Object result = null;

		try {
			Object target = this.target;
			Class targetClass = target.getClass();
			if (this.getWsResource() instanceof WSDMBinding) {
				WSDMBinding binding = (WSDMBinding) this.getWsResource();
				target = this.target;
				targetClass = target.getClass();
				if(target instanceof ManagementProxy){
					Method proxyMethod = ((ManagementProxy)target).getProxiedMethod(method);
					if(proxyMethod == null){
						target = ((ManagementProxy)target).getCapability(method.getDeclaringClass());
						if(target instanceof ManagementProxy)
							target = ((ManagementProxy)target).getProxiedObject();
					} else {
						target = ((ManagementProxy)target).getProxiedObject();
						method = proxyMethod;
					}
				}
			}
			System.out.println(method.getDeclaringClass() + " "
					+ target.getClass());
			result = method.invoke(target, params);
		}

		catch (Throwable error) {
			throw handleError(error);
		}

		return result;
	}

	public void initializeBindingInfo(WSDMInfo wsdmInfo, String namespace,
			String prefix) {
		this.info = wsdmInfo.getInfo();
		this.namespace = namespace;
		int propertiesLength = info.getAttributes().length;
		if(info.getResourceIdField() != null) propertiesLength-=1;
		if(propertiesLength > 0){
			properties = new QName[propertiesLength];
			propertiesLength = 0;
			int i=0;
			for(ManagedAttributeInfo attr: (ManagedAttributeInfo[])info.getAttributes()){
				if(attr.isResourceID()) continue;
				String ns = attr.getOwnerNamespace();
				if(!ns.equals(namespace))continue;
				QName propName = new QName(attr.getNamespace(),attr.getName(),prefix);
				getterMap.put(propName, attr.getGetter());
				if(attr.getSetter() != null) setterMap.put(propName, attr.getSetter());
				properties[i++] = propName;
				propertiesLength = i; //truncate length to only include the props for this namespace.
			}
		}
		QName [] actualProps = new QName[propertiesLength];
		for(int i=0;i<propertiesLength;i++){
			actualProps[i] = properties[i];
		}
		properties = actualProps;
		ManagedOperationInfo[] operations = (ManagedOperationInfo[])info.getOperations();
		for(ManagedOperationInfo operation: operations){
			if(!operation.getNamespace().equals(namespace))continue;
			//TODO create a message handler
			// using the method and the action
			WSDMOperation wsdmOper = operation.getAnnotation(WSDMOperation.class);
			String actionURI = namespace + "/" + operation.getName();
			QName inputName = new QName(namespace,operation.getName()+"RequestType", "dyn");
			QName outputName = new QName(namespace,operation.getName()+"ResponseType", "dyn");
			if(wsdmOper != null){
				if(!"".equals(wsdmOper.soapAction())){
					actionURI = wsdmOper.soapAction();
				}
				if(!"".equals(wsdmOper.inputName())){
					inputName = new QName(namespace,wsdmOper.inputName());
				}
				if(!"".equals(wsdmOper.outputName())){
					outputName = new QName(namespace,wsdmOper.outputName());
				}
			}
			DynamicInvocationHandler handler = new DynamicInvocationHandler(actionURI, inputName, outputName);
			handler.setMethod(operation.getOperationMethod());
			setMessageHandler(handler);
		}
	}

}
