/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;

import javax.xml.namespace.QName;

import org.apache.muse.core.routing.AbstractMessageHandler;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.properties.get.impl.GetRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicInvocationHandler extends AbstractMessageHandler {
	
	private Method method;
	private QName outputName;
	
    //
    // Used to lookup all exception messages
    //
    private static Messages _MESSAGES = MessagesFactory.get(GetRequest.class);
	
	public DynamicInvocationHandler(String action, QName inputName, QName outputName){
		super(action, inputName);
		this.outputName = outputName;
	}
	
	public void setMethod(Method method){
		this.method = method;
	}

	public Object[] fromXML(Element xml) throws SoapFault {
		int parmLength = method.getParameterTypes().length;
		Object[] returnList = new Object[2];
		Object[] parms = new Object[parmLength];
		returnList[0] = method;
		returnList[1] = parms;
		int i = 0;
		
		System.out.println("Input: " + XmlUtils.toString(xml));
		
		Element nodes[] = XmlUtils.getAllElements(xml, this.getRequestName().getNamespaceURI());
		try {
		for(Class parmType : method.getParameterTypes()){
			Node node = nodes[i];
	        Serializer ser = SerializerRegistry.getInstance().getSerializer(parmType);
	        if(ser != null){
	        	parms[i] = ser.fromXML(nodes[i]);
	        }
			i++;
		}
		return returnList;
		} catch(Throwable t){
			throw new SoapFault(t);
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.apache.muse.core.routing.AbstractMessageHandler#toXML(java.lang.Object)
	 *     public Element toXML()
    {
        return toXML(XmlUtils.EMPTY_DOC);
    }
    
    public Element toXML(Document doc)
    {
        if (doc == null)
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        
        return XmlUtils.createElement(doc, WsrpConstants.GET_QNAME, getQName());
    }

	 */
	
	protected Element toXML(Document doc, Object result) throws SoapFault{
        if (doc == null)
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        
        System.out.println(Void.class + " " + void.class + " " + method.getReturnType());
        if(void.class.equals(method.getReturnType()) || Void.class.equals(method.getReturnType())){
        	return XmlUtils.createElement(doc, outputName);
        }
        
        Serializer ser = null;
        try {
        	ser = SerializerRegistry.getInstance().getSerializer(method.getReturnType());
        }catch(Throwable t){
        }

        if(ser == null && Collection.class.isAssignableFrom(method.getReturnType())){
        	Type ret = method.getGenericReturnType();
        	if(ret instanceof ParameterizedType){
        		Type actuals[] = ((ParameterizedType)ret).getActualTypeArguments();
        		if(actuals.length > 0){
                	Class parmType = (Class)actuals[0];
                	ser = SerializerRegistry.getInstance().getSerializer(parmType);
                	if(ser == null){
                    	throw new SoapFault("No serializer found for class " + method.getReturnType());
                	}else{
                    	Element retElement = XmlUtils.createElement(doc, outputName);
                    	Collection<Object> collection = (Collection<Object>)result;
                    	for(Object obj : collection){
                    		Element next = ser.toXML(obj, outputName);
                    		retElement.appendChild(next);
                    	}
                    	System.out.println("Returning " + XmlUtils.toString(retElement));
                    	return retElement;
                	}
        		} else{
                	throw new SoapFault("No serializer found for class " + method.getReturnType());
        		}
        	}else{
            	throw new SoapFault("No serializer found for class " + method.getReturnType());
        	}
        }else if(ser != null){
        	Element ret = ser.toXML(result, outputName);
        	System.out.println("Returning " + XmlUtils.toString(ret));
        	return ret;
        } else {
        	throw new SoapFault("No serializer found for class " + method.getReturnType());
        }
	}

	public Element toXML(Object result) throws SoapFault {
		return toXML(XmlUtils.EMPTY_DOC, result);
	}
	
	public Method getMethod(){
		try {
			return DynamicCapability.class.getDeclaredMethod("invokeCustomMethod", new Class[]{Method.class, Object[].class});
		} catch (SecurityException e) {
			return null;
		} catch (NoSuchMethodException e) {
			return null;
		}
	}
	
}
