/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.WeakHashMap;

import javax.xml.namespace.QName;

import org.apache.muse.core.Capability;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.OperationalStatus;
import org.apache.muse.ws.dm.muws.Participant;
import org.apache.muse.ws.dm.muws.RelationshipType;
import org.apache.muse.ws.dm.muws.Relationships;
import org.apache.muse.ws.dm.muws.events.Component;
import org.apache.muse.ws.dm.muws.events.ComponentAddress;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.dm.muws.events.Situation;
import org.apache.muse.ws.dm.muws.events.WefFactory;
import org.apache.muse.ws.dm.muws.events.impl.SimpleWefFactory;
import org.apache.muse.ws.dm.muws.impl.SimpleParticipant;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationshipType;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.resource.properties.get.GetCapability;
import org.eclipse.cosmos.me.management.annotations.CreateManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedEvent;
import org.eclipse.cosmos.me.management.annotations.ManagedEventSituation;
import org.eclipse.cosmos.me.management.annotations.ManagedEventSource;
import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.api.EventSituation;
import org.eclipse.cosmos.me.management.api.EventSource;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.BindingStructureHelper;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedRelationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMNotificationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMRelationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.util.SchemaHelper;
import org.eclipse.cosmos.me.management.provisional.wsdm.util.WSDMHelperRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WSDMBindingFactory implements Binding, WSDMHelperRegistry {

	private static WefFactory wefFactory = new SimpleWefFactory();

	public static final WSDMAttributeInfo[] EMPTY_ATTR_INFO_ARRAY ={};
	public static final WSDMOperationInfo[] EMPTY_OPER_INFO_ARRAY ={};
	public static final WSDMRelationInfo[] EMPTY_RELATION_INFO_ARRAY ={};
	public static final WSDMNotificationInfo[] EMPTY_NOTIFICATION_INFO_ARRAY ={};
	private static final Field[] EMPTY_FIELD_ARRAY = {};

	protected static WeakHashMap<Object, WsResource> boundObjectMap = new WeakHashMap<Object, WsResource>();
	protected static WeakHashMap<Class, WSDMInfo> boundClassMap = new WeakHashMap<Class, WSDMInfo>();

	protected static HashMap<String, EndpointReference> advertisementMap = new HashMap<String, EndpointReference>();

	//FIXME need an interface type
	protected static HashMap<String, Object> capabilityFactoryMap = new HashMap<String, Object>();

	protected ResourceRouter _router;
	protected ResourceManager _resourceManager;
	protected ContributionManager _manager;
	
	static {
		port = System.getProperty("org.osgi.service.http.port","80");
	}
	
	protected static String contextPath = "cosmos";
	protected static String port;


	protected STATUS status = STATUS.PARTIALLY_AVAILABLE;
	
	protected static WSDMBindingFactory _default;	
	
	protected static WSDMBindingFactory createInstance(){
		return null;
	}

	public static WSDMBindingFactory getDefault(){
		if(_default == null) _default = createInstance();
		return _default;
	}


	public void setResourceRouter(ResourceRouter router){
		this._router = router;
		loadAdvertisementTargets();
	}

	public void setResourceManager(ResourceManager manager){
		this._resourceManager = manager;
	}
	
	public void setContributionManager(ContributionManager manager){
		_default._manager = manager;
	}


	public static void register(Object resource) throws Exception {
	}
	
	public void postProcessRegistration(WSDMBinding binding){
	}


	public void bindContribution(Object contribution, boolean register) {
		try {
			WSDMBinding binding = null;
			if(register){
				ManagedResourceInfo info = BindingStructureHelper.getResourceInfo(contribution);
				ManagedAttributeInfo[] attributes = (ManagedAttributeInfo[])info.getAttributes();
				ManagedOperationInfo[] operations = (ManagedOperationInfo[])info.getOperations();
				ManagedNotificationInfo[] notifications =  (ManagedNotificationInfo[])info.getNotifications();
				ManagedRelationInfo[] relations =  (ManagedRelationInfo[])info.getRelations();
				ManagedAttributeInfo id = info.getResourceIdField();
				WSDMInfo wsdmInfo = new WSDMInfo(info, contribution);
				wsdmInfo.compileCapabilties(_default._router.getEnvironment(), info);

				//decorate info with WSDM-specific stuff? 
				//Keep a map of info-wsdm_info?
				binding = new WSDMBinding(wsdmInfo, contribution);
				binding.setLog(_default._router.getLog());
				binding.setEnvironment(_default._router.getEnvironment());
				binding.setResourceManager(_default._resourceManager);
				binding.setContextPath("/"+info.getResourceName());
				binding.setWsdlPath("");
				binding.setWsdlPortType(new QName(info.getTargetNamespace(),info.getResourceName()+"PortType"));
				binding.initialize();
				_default._resourceManager.addResource(binding.getEndpointReference(), binding);
				boundObjectMap.put(contribution, binding);
				if(contribution instanceof ManagementProxy){
					boundObjectMap.put(((ManagementProxy)contribution).getProxiedObject(), binding);
				}
				postProcessRegistration(binding);
			}else{
				ManagedResourceInfo info = BindingStructureHelper.getResourceInfo(contribution);
				WSDMInfo wsdmInfo = new WSDMInfo(info, contribution); 
				wsdmInfo.compileCapabilties(_default._router.getEnvironment(), info);
				binding = new WSDMBinding(wsdmInfo, contribution);
				binding.setLog(_default._router.getLog());
				binding.setEnvironment(_default._router.getEnvironment());
				binding.setResourceManager(_default._resourceManager);
				binding.setContextPath("/"+info.getResourceName());
				binding.setWsdlPath("");
				binding.setWsdlPortType(new QName(info.getTargetNamespace(),info.getResourceName()+"PortType"));
				binding.initialize();
				_default._resourceManager.addResource(binding.getEndpointReference(), binding);
				boundObjectMap.put(contribution, binding);
				if(contribution instanceof ManagementProxy){
					boundObjectMap.put(((ManagementProxy)contribution).getProxiedObject(), binding);
				}
			}
			if(binding != null) {
				System.out.println(binding.toString());
			}
		} catch(Exception e){
			e.printStackTrace();
		}
	}

	public void unbindContribution(Object contribution) {
		boundObjectMap.remove(contribution);
		if(contribution instanceof ManagementProxy){
			boundObjectMap.remove(((ManagementProxy)contribution).getProxiedObject());
		}
	}

	//Provisional API based on annotations
	public void addRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
		System.out.println("Adding relationship");
		WsResource resource = boundObjectMap.get(object);
		if(resource == null || !(resource instanceof WSDMBinding))return;
		try {
			Relationships relCap = (Relationships)resource.getCapability(MuwsConstants.RELATIONSHIPS_URI);
			if(relCap == null){
				return;
			}
			WsResource targetResource = boundObjectMap.get(args[0]);
			if(targetResource == null){
				System.out.println("cannot locate relationship target");
				return;
			}
			String name = "contains";
			String relationType = "container";
			String role[] = {"container","contained"};

			for(Annotation annotation : annotations){
				if(annotation instanceof ManagedRelation){
					ManagedRelation managedRelation = (ManagedRelation)annotation;
					if(!"".equals(managedRelation.name())) name = managedRelation.name();
					role = managedRelation.roles();
					relationType = managedRelation.type();
				}else if(annotation instanceof CreateManagedRelation){
					CreateManagedRelation managedRelation = (CreateManagedRelation)annotation;
					if(!"".equals(managedRelation.name())) name = managedRelation.name();
					role = managedRelation.roles();
					relationType = managedRelation.type();
				}
			}
			Participant[] participants = new Participant[2];
			//TODO need ability to override relationship namespace
			QName typeNames[] = {new QName(((WSDMBinding)resource).getNamespace(),relationType,"tns")};
			RelationshipType type = new SimpleRelationshipType(typeNames);
			participants[0] = new SimpleParticipant(resource, role[0]);
			participants[1] = new SimpleParticipant(targetResource, role[1]);
			relCap.addRelationship(name, type, participants);

		} catch(Throwable t){
			t.printStackTrace();
		}
	}

	public void raiseEvent(Object object, Method method, Object[] args, Object ret, Annotation[] annotations) {
		WsResource binding = this.boundObjectMap.get(object);
		if(binding == null || !(binding instanceof WSDMBinding))return;
		Capability wsnCapability = binding.getCapability(WsnConstants.PRODUCER_URI);
		if(wsnCapability != null && wsnCapability instanceof NotificationProducer){
			ManagedEvent event = null;
			//TODO shouldn't have to search
			//TODO Need to add topic name to notification capability during compilation process...
			for(Annotation annotation : annotations){
				if(annotation instanceof ManagedEvent){
					event = (ManagedEvent)annotation;
					break;
				}
			}
			String namespace = event.namespace();
			String format = event.format();
			if("".equals(namespace)){
				//check for capability annoation
				for(Annotation annotation : annotations){
					if(annotation instanceof ManagedResourceCapability){
						namespace = ((ManagedResourceCapability)annotation).namespace();
						break;
					}
				}
				if("".equals(namespace)) namespace = ((WSDMBinding)binding).getNamespace();
			}
			QName topicName = new QName(namespace,event.topic(),"dyn");
			try {
				Element payload = XmlUtils.createElement(topicName,"value");
				if(ret != null){
					if(ret instanceof Element){
						payload = (Element)ret;
					} else {
						Serializer ser = SerializerRegistry.getInstance().getSerializer(ret.getClass());
						if(ser != null){
							payload = ser.toXML(ret, topicName);
						}
					}
				}
				if("wef".equals(format)){
					ManagementEvent wefEvent = wefFactory.createEvent();
					//FIXME - this is clearly wrong!!!
					wefEvent.setEventID(event.topic());

					if(payload != null){
						wefEvent.addExtendedElement(payload);
					}

					Component reporter = wefFactory.createComponent(binding.getEndpointReference().toXML());
					reporter.setName(new QName(((WSDMBinding)binding).getNamespace(),"reporter","dyn"));
					wefEvent.setReporter(reporter);
					Date currentTime = new Date(System.currentTimeMillis());
					wefEvent.setReportTime(currentTime);

					Annotation[][] parmAnnotationList = method.getParameterAnnotations();
					int currentParmIndex = 0;
					EventSource sourceHelper = null;
					EventSituation situationHelper = null;

					for(Annotation[] parmAnnotations : parmAnnotationList){
						if(parmAnnotations.length > 0){
							for(Annotation annotation : parmAnnotations){
								if(annotation instanceof ManagedEventSource){
									Object arg = args[currentParmIndex];
									if(arg instanceof EventSource)
										sourceHelper = (EventSource)arg;
								}
								if(annotation instanceof ManagedEventSituation){
									Object arg = args[currentParmIndex];
									if(arg instanceof EventSituation)
										situationHelper = (EventSituation)arg;
								}
							}
						}
						currentParmIndex++;
					}

					Component source = wefFactory.createComponent();
					if(sourceHelper != null){
						source.setName(sourceHelper.getName());
						Object managedSource = sourceHelper.getManagedObject();
						if(managedSource != null){
							WsResource sourceBinding = boundObjectMap.get(object);
							ComponentAddress sourceAddress = null;
							if(sourceBinding != null){
								 sourceAddress =
									wefFactory.createComponentAddress(sourceBinding.getEndpointReference().toXML());
							}else{
								sourceAddress = wefFactory.createComponentAddress();
							}
							source.setAddress(sourceAddress);
							Properties props = sourceHelper.getSourceProperties();
							for(Object key : props.keySet()){
								if(key instanceof QName){
									source.addExtendedElement((QName)key, props.get(key));
								}
							}
						}
					}else{
						source.setName(new QName("bogus","source"));
						ComponentAddress sourceAddress = wefFactory.createComponentAddress();
						source.setAddress(sourceAddress);
					}
					wefEvent.setSource(source);

					//TODO wef situations???
					Situation situation = wefFactory.createSituation();
					if(situationHelper != null){
						situation.setCategoryType(situationHelper.getCategoryType());
						situation.setMessage(situationHelper.getMessage());
						situation.setSeverity(situationHelper.getSeverity());
						situation.setPriority(situationHelper.getPriority());
						situation.setSuccessDisposition(situationHelper.getSuccessDisposition());
					}else{
						situation.setCategoryType(new QName("bugus","category"));
						situation.setMessage("Hello there");
						situation.setPriority(Situation.LOW_PRIORITY);
						situation.setSeverity(Situation.INFO_SEVERITY);
						situation.setSituationTime(currentTime);
					}
					wefEvent.setSituation(situation);

					payload = wefEvent.toXML();
				}
				((NotificationProducer)wsnCapability).publish(topicName, payload);
			} catch (SoapFault e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	public void removeRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
		System.out.println("Removing relationship");
		WsResource resource = boundObjectMap.get(object);
		if(resource == null || !(resource instanceof WSDMBinding))return;
		try {
			Relationships relCap = (Relationships)resource.getCapability(MuwsConstants.RELATIONSHIPS_URI);
			if(relCap == null){
				return;
			}
			WsResource targetResource = boundObjectMap.get(args[0]);
			if(targetResource == null){
				System.out.println("cannot locate relationship target");
				return;
			}
			String name = "contains";
			String relationType = "container";
			String role[] = {"container","contained"};

			for(Annotation annotation : annotations){
				if(annotation instanceof ManagedRelation){
					ManagedRelation managedRelation = (ManagedRelation)annotation;
					if(!"".equals(managedRelation.name())) name = managedRelation.name();
					role = managedRelation.roles();
					relationType = managedRelation.type();
				}
			}
			Participant[] participants = new Participant[2];
			QName typeNames[] = {new QName(((WSDMBinding)resource).getNamespace(),relationType,"tns")};
			RelationshipType type = new SimpleRelationshipType(typeNames);
			participants[0] = new SimpleParticipant(resource, role[0]);
			participants[1] = new SimpleParticipant(targetResource, role[1]);
			WsResource relationships[] = relCap.getRelationship();
			for(WsResource relationship : relationships){
				System.out.println(relationship);
				GetCapability getCap = (GetCapability)relationship.getCapability(WsrpConstants.GET_CAPABILITY);
				if(getCap == null) continue;
				Element testParts[] = getCap.getResourceProperty(MuwsConstants.PARTICIPANT_QNAME);
				Element testType[] = getCap.getResourceProperty(MuwsConstants.TYPE_QNAME);
				Element testName[] = getCap.getResourceProperty(MuwsConstants.NAME_QNAME);
				String testNameValue = testName[0].getTextContent();
				if(!name.equals(testNameValue))continue;
				Element typeMatch[] = XmlUtils.getElements(testType[0], typeNames[0]);
				if(typeMatch.length == 0) continue;
				SimpleParticipant tp1 = new SimpleParticipant(testParts[0]);
				SimpleParticipant tp2 = new SimpleParticipant(testParts[1]);
				if(isSameParticipant(participants[0],tp1) && isSameParticipant(participants[1],tp2)){
					System.out.println("Got a match!!!");
				}
			}

		} catch(Throwable t){
			t.printStackTrace();
		}
	}

	private boolean isSameParticipant(Participant p1, Participant p2){
		if(!p1.getManageabilityReference().equals(p2.getManageabilityReference()))return false;
		if(!p1.getResourceId().equals(p2.getResourceId()))return false;
		if(!p1.getRole().equals(p2.getRole()))return false;
		return true;
	}

	public void statusChanged(Object object, STATUS newStatus) {
		WsResource binding = boundObjectMap.get(object);
		if(binding != null){
			Capability capability = binding.getCapability(MuwsConstants.OP_STATUS_URI);
			if(capability != null && capability instanceof OperationalStatus){
				String status = OperationalStatus.UNKNOWN;
				if(newStatus == STATUS.AVAILABLE){
					status = OperationalStatus.AVAILABLE;
				}else if(newStatus == STATUS.PARTIALLY_AVAILABLE){
					status = OperationalStatus.PARTIALLY_AVAILABLE;
				}else if(newStatus == STATUS.UNAVAILABLE){
					status = OperationalStatus.UNAVAILABLE;
				}
				try {
					((OperationalStatus)capability).setOperationalStatus(OperationalStatus.UNKNOWN);
				} catch (BaseFault e) {
				}
			}
		}else if(object == this){
			status = newStatus;
		}
	}

	protected static void loadAdvertisementTargets(){
		
	}

	public static EndpointReference getAdvertisementTarget(String key){
		EndpointReference ref = advertisementMap.get(key);
		if(ref == null){
			String propValue = System.getProperty(key);
			if(propValue != null){
				try{
					InputStream stream = new ByteArrayInputStream(propValue.getBytes());
					Document doc = XmlUtils.createDocument(stream);
					ref = new EndpointReference(doc.getDocumentElement());
					System.out.println("Ref is " + ref);
					advertisementMap.put(key,ref);
				}catch(Throwable t){
					t.printStackTrace();
				}
			}
		}
		if(ref == null) ref = advertisementMap.get("default");
		return ref;
	}

	public STATUS getStatus() {
		return status;
	}

	public Object getBindingForObject(Object boundObject) {
		return this.boundObjectMap.get(boundObject);

	}

	public void registerSchemaHelper(Class type, SchemaHelper helper) {
		WSDMBindingUtil.registerSchemaHelper(type, helper);
	}

	public void registerSerializer(Class type, Serializer serializer) {
		SerializerRegistry.getInstance().registerSerializer(type, serializer);
		
	}
	
	public void registerCapabilityFactory(String uri, Class factory){
		BindingStructureHelper.setCapabilityFactory(uri,factory);
	}
	

	public String getBindingName() {
		return "WSDM";
	}

	public Document getWSDLDocument(Object resource) {
		// TODO Auto-generated method stub
		WSDMBinding binding = (WSDMBinding)this.getBindingForObject(resource);
		if(binding != null) return binding.getWsdlDocument();
		return null;
	}
	
	public String getContextPath(){
		return contextPath;
	}
	
	public String getPort(){
		return port;
	}

	public void setContextPath(String contextPathString){
		contextPath = contextPathString;
	}
	
	public void setPort(String portString){
		port = portString;
	}
	

}
