/*******************************************************************************
 * Copyright (c) 2005, 2007 Compuware Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;

import org.eclipse.cosmos.me.management.provisional.wsdm.util.SchemaHelper;

public class WSDMBindingUtil {
	
	private static Annotation[] EMPTY_ANNOTATION_LIST = {};
	

	private static HashMap<String, SchemaHelper>schemaMap = new HashMap<String, SchemaHelper>();
	
	public static void registerSchemaHelper(Class type, SchemaHelper helper) {
		schemaMap.put(type.getName(), helper);
	}

	public static SchemaHelper getSchemaHelper(Class type) {
		return schemaMap.get(type.getName());
	}

	public static SchemaHelper getSchemaHelper(String type) {
		return schemaMap.get(type);
	}

}
