package org.eclipse.cosmos.me.management.provisional.wsrf.capabilities;

import javax.xml.namespace.QName;

import org.apache.muse.ws.resource.WsrfConstants;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMOperation;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMResourceCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMSchemaImport;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.InvalidResourcePropertyQNameFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.ResourceUnavailableFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.ResourceUnknownFault;

@WSDMResourceCapability
@ManagedResourceCapability(namespace = "http://docs.oasis-open.org/wsrf/rpw-2/Get")
public interface GetCapability {
	
	@WSDMSchemaImport(location="WS-ResourceProperties-1_2.xsd")
	public static String WSRF_RESOURCE_PROPERTIES_NAMESPACE = "http://docs.oasis-open.org/wsrf/rp-2"; 

	@WSDMSchemaImport(location="WS-Resource-1_2.xsd")
	public static String WSRF_RESOURCE_NAMESPACE = "http://docs.oasis-open.org/wsrf/r-2"; 

	@WSDMOperation(soapAction=WsrpConstants.GET_RP_DOCUMENT_URI)
    @ManagedOperation
	Object getResourcePropertyDocument() throws ResourceUnknownFault, ResourceUnavailableFault;

    @ManagedOperation
    Object[] getResourceProperty(QName qname) throws ResourceUnknownFault, ResourceUnavailableFault, InvalidResourcePropertyQNameFault;
    
    @ManagedOperation
    Object[] getMultipleResourceProperties(QName[] qnames) throws ResourceUnknownFault, ResourceUnavailableFault, InvalidResourcePropertyQNameFault;
}
