package org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.impl;

import org.apache.muse.core.Capability;
import org.apache.muse.ws.resource.lifetime.impl.SimpleImmediateTermination;
import org.apache.muse.ws.resource.properties.query.impl.SimpleQueryCapability;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.ImmediateTerminationCapability;
import org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.QueryCapability;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.BaseFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.InvalidQueryExpressionFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.QueryEvaluationErrorFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.ResourceNotDestroyedFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.UnknownQueryExpressionDialectFault;

public class QueryCapabilityImpl implements QueryCapability, WSDMDelegator  {
	
	
	private SimpleQueryCapability delegateCapability = new SimpleQueryCapability(); 
	
	@ManagedFrameworkAutowire(name = "$RESOURCE")
	Object resource;
	
	public void setResource(Object resource){
		this.resource = resource;
	}
	
	@ManagedFrameworkAutowire(name="WSDM")
	private Binding wsdmBinding;
	
	public void setWsdmBinding(Binding wsdmBinding){
		this.wsdmBinding = wsdmBinding;
	}
	
	public Capability getDelegateCapability() {
		return delegateCapability;
	}

	public String[] getQueryExpressionDialect() {
		// TODO Auto-generated method stub
		return null;
	}

	public Object[] queryResourceProperties(String query, String dialect)
			throws UnknownQueryExpressionDialectFault,
			InvalidQueryExpressionFault, QueryEvaluationErrorFault, BaseFault {
		// TODO Auto-generated method stub
		return null;
	}

}
