/*******************************************************************************
 * Copyright (c) 2005, 2007 Compuware Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.management.wsdm.osgi;

import java.net.InetAddress;
import java.net.URI;
import java.util.Hashtable;

import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.sg.remote.ServiceGroupClient;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.StatusChangeListener;
import org.eclipse.cosmos.me.management.wsdm.osgi.OSGiWSDMBindingFactory;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBindingFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class WSDMBindingService extends OSGiWSDMBindingFactory {
	
	private BundleContext ctx;
	
	protected void activate(ComponentContext ctxt)
	{
		this.ctx = ctxt.getBundleContext();
		start(ctx);
	}
	
	protected void deactivate(ComponentContext ctxt)
	{
		BundleContext context = ctxt.getBundleContext();
		stop(context);
	}
	
	/**
	 * Start handling events.
	 * 
	 * This method should be called by the plugin/bundle's Activator when
	 * it is started.
	 * 
	 * @param ctxBundle bundle context
	 */
	private void start(BundleContext ctxBundle ) {

		
		ServiceReference managementServiceRef = ctxBundle.getServiceReference(ResourceManagementProvider.class.getName());
		ResourceManagementProvider managementProvider = (ResourceManagementProvider)ctxBundle.getService(managementServiceRef);
		//registr runtime deserializers
		((OSGiWSDMBindingFactory)OSGiWSDMBindingFactory.getDefault()).setWSDMProvider(managementProvider);
		//register spec deserializers
//			managementProvider.registerResourceDefinitionCallback(context.getBundle(), ManagementBinding.getDefault());
//			managementProvider.registerCreateStartupResourcesCallback(context.getBundle(), ManagementBinding.getDefault());
		Thread museThread = new Thread(new Runnable() {
			public void run() {
				warmUpMuse();
			}
		});
		museThread.start();
		try {
			museThread.join();
		} catch (InterruptedException e) {}

		// registger OSGi event handler
		Hashtable<String, Object> providerProperties = new Hashtable<String, Object>();
		providerProperties.put(Binding.PROVIDER_NAME,"WSDM");
//		providerProperties.put(Binding.PROVIDER_MAJOR_VERSION,new Integer(1));
//		providerProperties.put(Binding.PROVIDER_MINOR_VERSION,new Integer(1));
//		srvRegistration  = ctxBundle.registerService(
//				Binding.class.getName(),
//				WSDMBindingFactory.getDefault(), providerProperties);
	}

	/**
	 * Stop handling events 
	 *
	 * This method should be called by the plugin/bundle's Activator when
	 * it is stopped.
	 * 
	 * @param ctxBundle bundle context
	 */
	private void stop(BundleContext ctxBundle) {
//		srvRegistration.unregister();
	}
	
	private void warmUpMuse(){
		/*
		 * Warm up Muse...
		 */
        try
        {
            //
            // change these to point to different applications/servers
            //
            String webAppRoot = "/cosmos";
            String contextPath = webAppRoot + "/services/Relationships";
            String port = System.getProperty("org.osgi.service.http.port", "80");

            //
            // test WSSG directory
            //
            String ip = InetAddress.getLocalHost().getHostAddress();

            StringBuffer address = new StringBuffer();
            address.append("http://");
            address.append(ip);
            address.append(':');
            address.append(port);

            if (contextPath.charAt(0) != '/')
                address.append('/');

            address.append(contextPath);

            URI addressURI = URI.create(address.toString());


            EndpointReference epr = new EndpointReference(addressURI);

            ServiceGroupClient sg = new ServiceGroupClient(epr);

            //
            // ping SG, wait a few seconds, then check for members
            // that were added by the simulation factory
            //
            System.out.println("Pinging Muse to initialize the endpoint...");
            sg.getResourcePropertyDocument();
            System.out.println("Waiting 10 seconds while simulation creates WS-resources...");
        }catch(SoapFault s){
        	//We're expecting a "Destination Unreachable" error here...
        	if(!WsaConstants.DESTINATION_UNREACHABLE_FAULT_QNAME.equals(s.getSubCode())){
        		s.printStackTrace();
        	}
        }catch(Throwable t){
        	t.printStackTrace();
        }finally{
        	WSDMBindingFactory.getDefault().statusChanged(WSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
        }

	}
	

}
