/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.mdr.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.dataManager.impl.AbstractDataManager;
import org.eclipse.cosmos.dc.mdr.api.IMdrAdmin;
import org.eclipse.cosmos.dc.mdr.api.IMdrQuery;
import org.eclipse.cosmos.dc.mdr.exception.CMDBfException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMdr extends AbstractDataManager implements IMdrQuery, IMdrAdmin {

	private CMDBfQueryOperation queryOp = new CMDBfQueryOperation(getQueryHandlerFactory(), null);
	
	abstract public IQueryHandlerFactory getQueryHandlerFactory();
	
	protected CMDBfQueryOperation getQueryOperation() {
		return queryOp;
	}

	public Element graphQuery(Element queryRequest) throws CMDBfException {
		System.out.println("#### Executing MDR query ####");
		InputStream inputStream = toInputStream(queryRequest, "query");				
		
		try 
		{			
			IQueryResult result = queryOp.execute(inputStream);
			InputStream output = QueryOutputTransformer.transform(result);
			
			return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(output).getDocumentElement();
		} 
		catch (Exception e) 
		{
			throw new CMDBfException("Error in transforming query output to XML element", e);
		}		
	}
	
	
	protected InputStream toInputStream(Element request, String rootLocalName) throws CMDBfException 
	{
		try
		{
	        Node rootNode = null;	        
	        
			// Get the rootLocalName element under request node
	        NodeList nodelist = request.getChildNodes();
	        for (int i=0; i<nodelist.getLength(); i++) {
	        	Node next = nodelist.item(i);
	        	if (next.getNodeType() != Node.ELEMENT_NODE) {
	                continue;
	        	}
	        	if (next.getLocalName().equals(rootLocalName)) {
	        		rootNode = next;
	        		break;
	        	}
	        }
	        if (rootNode == null)  {
	        	throw new DataManagerException("Missing " + rootLocalName + " element in request");
	        }
	        
	        return toInputStream(rootNode);
		}
		catch (Exception e)
		{
			throw new CMDBfException("Failed to create input stream from request.");
		}
	}

	protected InputStream toInputStream(Node rootNode) throws CMDBfException
	{
		try
		{
			// Turn node to string
	        Transformer trans = TransformerFactory.newInstance().newTransformer();
	        StringWriter sw = new StringWriter();
	        trans.transform(new DOMSource(rootNode), new StreamResult(sw));
	
	        // Turn String into input stream
	        InputStream inputStream = new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
	        return inputStream;
		}
		catch (Exception e)
		{
			throw new CMDBfException("Failed to create input stream from request.");
		}
	}
}
