/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.mdr.client;

import javax.xml.namespace.QName;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.dc.dataManager.client.DataManagerClient;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.mdr.api.IMdrQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Client proxy of MDR. 
 *
 */
public class MdrClient extends DataManagerClient 
{

	public MdrClient(EndpointReference destination) 
	{
		super(destination);		
	}
	

	/**
	 * Queries this MDR with the CMDBf query request passed
	 * in
	 * 
	 * @param queryRequest The query request conforming to the CMDBf
	 * specification
	 * 
	 * @return An element representing the query response as it conforms
	 * to the CMDBf specification
	 *  
	 * @throws DataManagerException In case of any unexpected errors
	 */
	public Element query(Element queryRequest) throws DataManagerException 
	{
		return invokeRemoteOperation(queryRequest, IMdrQuery.QUERY_OP_QNAME, IMdrQuery.QUERY_REQUEST_QNAME, IMdrQuery.QUERY_OP_URI);
	}
	
	
	protected Element invokeRemoteOperation(Element elementRequest, QName operation, QName request, String operationURI) throws DataManagerException
	{
		// Construct the soap body
		Element soapBody = XmlUtils.createElement(operation);		
		
		// Construct the request
		if (elementRequest != null)
		{
			Element requestBody = XmlUtils.createElement(request);
			Node adoptedNode = requestBody.getOwnerDocument().importNode(elementRequest, true);
			
			requestBody.appendChild(adoptedNode);
			soapBody.appendChild(requestBody);
		}
		
		try 
		{
			Element result = invoke(operationURI, soapBody);
			return result;
		} 
		catch (SoapFault e) 
		{
			throw new DataManagerException(e);
		}
	}
	
	protected Element invokeRemoteOperation(QName operation, String operationURI) throws DataManagerException
	{
		return invokeRemoteOperation(null, operation, null, operationURI);
	}
}
