/*******************************************************************************
 * Copyright (c) 2008 CA Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.e2e.dc.birt.helper;

import java.net.URI;
import java.util.Collection;
import org.eclipse.cosmos.common.exceptions.CosmosException;

import org.eclipse.cosmos.dc.logging.datamgr.ws.client.CBEClient;
import org.eclipse.cosmos.dc.logging.datamgr.ws.client.CBESeverityCount;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
	
public class NewHelper {

	private static NewHelper instance = new NewHelper();
			
	public static NewHelper getNewHelperInstance(){
		return instance;
	}
		
		
	public Collection<CommonBaseEvent> getAllCBE(String address,String logfile) throws Exception {
		Collection<CommonBaseEvent> e = null;
		CBEClient dmc = null;
				
		System.out.println("GetAllCBE " + address + " " + logfile);
		
		try {
			dmc = new CBEClient(address);
			e = dmc.getAllCBE(logfile);
		} catch (CosmosException ae) {
			ae.printStackTrace();
			return null;
		}
		return e;
	}
		
	public Collection<CBESeverityCount> getCBECountBySeverity(String address,String logfile) throws Exception {
		Collection<CBESeverityCount> sev = null;
		CBEClient dmc = null;
		URI addr = null;
		
		System.out.println("CBECountBySeverity " + address + " " + logfile);
		
		try { 
			dmc = new CBEClient(address);	
			sev = dmc.getCBECountBySeverity(logfile);
		} catch (CosmosException ae) {
			ae.printStackTrace();
			return null;
		}
		return sev;
	}
}

