/*******************************************************************************
 * Copyright (c) 2008 CA Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.e2e.dc.birt.helper;

import java.net.URI;
import java.util.Collection;
import org.eclipse.cosmos.common.exceptions.CosmosException;

import org.eclipse.cosmos.dc.stat.datamgr.ws.client.StatisticalTuple;
import org.eclipse.cosmos.dc.stat.datamgr.ws.client.IStatisticalClient;
import org.eclipse.cosmos.dc.stat.datamgr.ws.client.StatisticalDataManagerClient;

public class StatHelper {
	private static StatHelper instance = new StatHelper();
	
	public static StatHelper getStatHelperInstance(){
		return instance;
	}
	
 
	public Collection<StatisticalTuple> getStatDataForSource(String addr,String dataset,String keyset, int start,int size)
	{
		IStatisticalClient dmc = null;
		Collection<StatisticalTuple> sds = null;
		
		try {
			dmc = new StatisticalDataManagerClient(addr);
			sds = dmc.getStatDataForSource(dataset,keyset,start,size);
		} catch (CosmosException e) {
			e.printStackTrace();
			return null;
		}
		
		return sds;
	}

}


