/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.impl;

import org.apache.muse.core.Capability;
import org.apache.muse.ws.dm.muws.impl.SimpleDescription;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.DescriptionCapability;

public class DescriptionImpl implements DescriptionCapability, WSDMDelegator {
	
	private SimpleDescription delegate;
	
	public DescriptionImpl(){
		delegate = new SimpleDescription();
	}

	public Capability getDelegateCapability() {
		return delegate;
	}

	public String[] getCaption() {
		return delegate.getCaption();
	}

	public String[] getDescription() {
		return delegate.getDescription();
	}

	public String getVersion() {
		return delegate.getVersion();
	}

	public void setCaption(String[] captions) {
		delegate.setCaption(captions);
	}

	public void setDescription(String[] descriptions) {
		delegate.setDescription(descriptions);
	}

	public void setVersion(String version) {
		delegate.setVersion(version);
	}
	
	
}
