/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.impl;

import org.apache.muse.core.Capability;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.impl.SimpleIdentity;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.IdentityCapability;

@ManagedResourceCapability(namespace="http://docs.oasis-open.org/wsdm/muws/capabilities/Identity")
public class IdentityImpl extends SimpleIdentity implements IdentityCapability, WSDMDelegator {
	
	String identity;

	public IdentityImpl(String identity){
		this.identity = identity;
	}
	
    public String getResourceId()
    {
       return identity;
    }
    
    public void initialize()
        throws SoapFault
    {
        super.initialize();
    }

	public Capability getDelegateCapability() {
		return this;
	}
	
	
}
