/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

import javax.xml.namespace.QName;

import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.eclipse.cosmos.me.management.annotations.ManagedMetric;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DynamicMetadataDescriptor implements MetadataDescriptor {
	
	private HashMap<QName, HashMap<QName, String>> extendedMetadataMap = new HashMap<QName, HashMap<QName, String>>();
	
	public DynamicMetadataDescriptor(ManagedResourceInfo info, Element wsdl){
        if(info.hasMetrics()){
        	ManagedAttributeInfo attributes[] = (ManagedAttributeInfo[])info.getAttributes();
        	for(ManagedAttributeInfo attribute : attributes){
        		if(attribute.isMetric()){
        			String namespace = attribute.getNamespace();
        			if("".equals(namespace)) namespace = attribute.getOwnerNamespace();
        			if("".equals(namespace)) namespace = info.getTargetNamespace();
        			QName propertyName = new QName(namespace,attribute.getName(),"dyn");
        			setExtendedMetadata(propertyName, MuwsConstants.CAPABILITY_QNAME, MuwsConstants.METRICS_URI);
        			Annotation[] annotations = attribute.getAnnotations();
        			for(Annotation annotation : annotations){
        				if(annotation instanceof ManagedMetric){
        					ManagedMetric metric = (ManagedMetric)annotation;
        					ManagedMetric.CHANGE_TYPE type = metric.changeType();
        					String interval = metric.calulationInterval();
        					ManagedMetric.GATHERING_TIME gatheringTime = metric.gatheringTime();
        					ManagedMetric.TIME_SCOPE scope = metric.timeScope();
        					String time = "";
        					if(scope.equals(ManagedMetric.TIME_SCOPE.INTERVAL)){
        						time=MuwsConstants.INTERVAL;
        					}else if(scope.equals(ManagedMetric.TIME_SCOPE.POINT_IN_TIME)){
        						time=MuwsConstants.POINT_IN_TIME;
        					}else if(scope.equals(ManagedMetric.TIME_SCOPE.SINCE_RESET)){
        						time=MuwsConstants.SINCE_RESET;
        					}
        			        setExtendedMetadata(propertyName, MuwsConstants.TIME_SCOPE_QNAME,time);

        			        String change = "";
        			        if(type.equals(ManagedMetric.CHANGE_TYPE.COUNTER)){
        			        	change = MuwsConstants.COUNTER;
        			        }else if(type.equals(ManagedMetric.CHANGE_TYPE.GAUGE)){
        			        	change = MuwsConstants.GAUGE;        			       
        			        }else if(type.equals(ManagedMetric.CHANGE_TYPE.UNKNOWN)){
        			        	change = MuwsConstants.UNKNOWN;
        			        }
        			        setExtendedMetadata(propertyName, MuwsConstants.CHANGE_TYPE_QNAME,change);

        			        String gathering = "";
        			        if(gatheringTime.equals(ManagedMetric.GATHERING_TIME.ON_CHANGE)){
        			        	gathering = MuwsConstants.ON_CHANGE;
        			        }else if(gatheringTime.equals(ManagedMetric.GATHERING_TIME.ON_DEMAND)){
        			        	gathering = MuwsConstants.ON_DEMAND;
        			        }else if(gatheringTime.equals(ManagedMetric.GATHERING_TIME.PERIODIC)){
        			        	gathering = MuwsConstants.PERIODIC;
        			        }
        			        setExtendedMetadata(propertyName, MuwsConstants.GATHERING_QNAME,gathering);
        			        
        			        if("".equals(interval) == false){
        			        	setExtendedMetadata(propertyName, MuwsConstants.CALC_INTERVAL_QNAME,interval);
        			        }

        			        setExtendedMetadata(propertyName, MuwsConstants.METRIC_GROUP_QNAME,metric.group());
        					
        				}
        			}
        		}
        	}
        }
	}

	public void addProperty(QName property, String modifiability, String mutability) {
		// TODO Auto-generated method stub
		
	}

	public boolean canDelete(QName property) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean canInsert(QName property) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean canUpdate(QName property) {
		// TODO Auto-generated method stub
		return true;
	}

	public String getExtendedMetadata(QName property, QName elementName) {
		HashMap<QName, String> extendedData = this.extendedMetadataMap.get(property);
		if(extendedData != null){
			return extendedData.get(elementName);
		}
		return null;
	}

	public Collection getInitialValues(QName property) {
		return Collections.EMPTY_LIST;
	}

	public Collection getInitialValues(QName property, Class javaType) throws SoapFault {
		return Collections.EMPTY_LIST;
	}

	public QName getInterface() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getLowerBound(QName property) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getModifiability(QName property) {
		// TODO Auto-generated method stub
		return WsrmdConstants.READ_WRITE;
	}

	public String getMutability(QName property) {
		// TODO Auto-generated method stub
		return WsrmdConstants.MUTABLE;
	}

	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}

	public Collection getPropertyNames() {
		return this.extendedMetadataMap.keySet();
	}

	public Collection getStaticValues(QName property) {
		return Collections.EMPTY_LIST;
	}

	public Collection getStaticValues(QName property, Class javaType) throws SoapFault {
		return Collections.EMPTY_LIST;
	}

	public String getUpperBound(QName property) {
		// TODO Auto-generated method stub
		return null;
	}

	public Collection getValidValues(QName property) {
		return Collections.EMPTY_LIST;
	}

	public Collection getValidValues(QName property, Class javaType) throws SoapFault {
		return Collections.EMPTY_LIST;
	}

	public String getWsdlLocation() {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean hasProperty(QName property) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isInitialValue(QName property, Object value) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isReadOnlyExternal(QName property) {
		return true;
	}

	public boolean isStaticValue(QName property, Object value) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isValidValue(QName property, Object value) {
		// TODO Auto-generated method stub
		return true;
	}

	public void removeProperty(QName property) {
		// TODO Auto-generated method stub
		
	}

	public void setExtendedMetadata(QName property, QName elementName, String value) {
		HashMap<QName, String> extendedData = this.extendedMetadataMap.get(property);
		if(extendedData == null){
			extendedData = new HashMap<QName, String>();
			this.extendedMetadataMap.put(property, extendedData);
		}
		extendedData.put(elementName, value);
	}

	public void setInitialValues(QName property, Collection values) throws SoapFault {
		// TODO Auto-generated method stub
		
	}

	public void setLowerBound(QName property, String value) {
		// TODO Auto-generated method stub
		
	}

	public void setModifiability(QName property, String value) {
		// TODO Auto-generated method stub
		
	}

	public void setMutability(QName property, String value) {
		// TODO Auto-generated method stub
		
	}

	public void setPropertyName(QName currentProperty, QName newProperty) {
		// TODO Auto-generated method stub
		
	}

	public void setStaticValues(QName property, Collection values) throws SoapFault {
		// TODO Auto-generated method stub
		
	}

	public void setUpperBound(QName property, String value) {
		// TODO Auto-generated method stub
		
	}

	public void setValidValues(QName property, Collection values) throws SoapFault {
		// TODO Auto-generated method stub
		
	}

	public Element toXML() {
		// TODO Auto-generated method stub
		return null;
	}

	public Element toXML(Document factory) {
		// TODO Auto-generated method stub
		return null;
	}

	public Collection getExtendedMetadataNames(QName arg0) {
		// TODO Auto-generated method stub
		return null;
	}
	
}
