/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.xml.namespace.QName;

import org.apache.muse.core.Resource;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.TopicListener;
import org.apache.muse.ws.notification.impl.SimpleNotificationConsumer;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationConsumerInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.DynamicBindingCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;

public class DynamicNotificationConsumer extends SimpleNotificationConsumer implements TopicListener, DynamicBindingCapability  {
	
	private WSDMInfo wsdmInfo;
	private ManagedResourceInfo info;
	
	public DynamicNotificationConsumer(){
		super();
		this.addMessageListener(this);
	}
	
    /**
     * 
     * This implementation spawns a thread to handle the passing of the message 
     * to the message listeners so that the method can return immediately and 
     * speed up the notification process for the reporter.
     * 
     */
    public void notify(NotificationMessage[] messages)
    {
    	super.notify(messages);
    }

	public QName getTopic() {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean accepts(NotificationMessage message) {
		// TODO Auto-generated method stub
		return true;
	}

	public void process(NotificationMessage message) throws SoapFault {
		QName topicName = message.getTopic();
		String targetTopic = "*";
		
		System.out.println(message.toString());
		ManagedNotificationConsumerInfo consumers[] = info.getConsumers();
		if(topicName != null) targetTopic = topicName.getNamespaceURI()+"/"+topicName.getLocalPart();
		for(ManagedNotificationConsumerInfo consumer : consumers){
			if(targetTopic.equals(consumer.getTopic())){
				//get the consumer method
				//get the correct invocation object
				//call that sucker...
				Method method = consumer.getOperation().getOperationMethod();
				Resource resource = this.getResource();
				WSDMBinding binding = (WSDMBinding)resource;
				Object obj = binding.getResource();
				System.out.println("Calling " + consumer.getTopic());
				Object []parms = {message};
				try {
					method.invoke(obj, parms);
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
	}

	public void initializeBindingInfo(WSDMInfo wsdmInfo, String namespace,
			String prefix) {
		this.wsdmInfo = wsdmInfo;
		info = wsdmInfo.getInfo();
	}
	
	
}
