/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.util.Collection;

import org.apache.muse.core.SimpleResourceManager;
import org.apache.muse.core.descriptor.ResourceDefinition;

public class DynamicResourceManager extends SimpleResourceManager {
	
    public void addResourceDefinitions(Collection definitions)
    {
        if (definitions != null && !definitions.isEmpty())
            super.addResourceDefinitions(definitions);
    }
 	
    public boolean isUsingPersistence(String contextPath)
    {
        ResourceDefinition resourceDef =  getResourceDefinition(contextPath);
        if(resourceDef != null) return resourceDef.isUsingPersistence();
        return false;
    }

}
