/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

import javax.xml.namespace.QName;

import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.SimpleResource;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.adv.Advertisement;
import org.apache.muse.ws.dm.muws.impl.SimpleIdentity;
import org.apache.muse.ws.dm.muws.impl.SimpleManageabilityCharacteristics;
import org.apache.muse.ws.dm.muws.impl.SimpleMetrics;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationships;
import org.apache.muse.ws.metadata.WsxConstants;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.impl.SimpleNotificationConsumer;
import org.apache.muse.ws.notification.impl.SimpleNotificationProducer;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.OpenMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability;
import org.apache.muse.ws.resource.properties.impl.SimpleResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.query.impl.SimpleQueryCapability;
import org.apache.muse.ws.resource.properties.schema.OpenPropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.impl.SimpleResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetCapability;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.eclipse.cosmos.me.management.common.BindingStructureHelper;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;
import org.eclipse.cosmos.me.management.common.util.SequentialResourceIDFactory;
import org.eclipse.cosmos.me.management.provisional.wsdm.DynamicBindingCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsdm.capabilities.impl.IdentityImpl;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDMBinding extends SimpleResource implements WsResource {

	private Object resource;
	private String resourceId;
	private Document wsdl;
	//
    // WSRP state model
    //
    private ResourcePropertyCollection _properties = null;

    //
    // Used to lookup all exception messages
    //
    private static Messages _MESSAGES = MessagesFactory.get(SimpleResource.class);

	private WSDMInfo wsdmInfo;

    public static URI getLocalAddress(String contextPath, String port)
			throws UnknownHostException {
		String ip = InetAddress.getLocalHost().getHostAddress();
		String hostname = InetAddress.getLocalHost().getCanonicalHostName();

		StringBuffer address = new StringBuffer();
		address.append("http://");
		address.append(ip);
		address.append(':');
		address.append(port);

		if (contextPath.charAt(0) != '/')
			address.append('/');

		address.append(contextPath);

		return URI.create(address.toString());
	}

    Object getResource(){
    	return resource;
    }

    public String getNamespace(){
    	return wsdmInfo.getTargetNamespace();
    }

	public WSDMBinding(WSDMInfo wsdmInfo, Object resource){
		this.wsdmInfo = wsdmInfo;
		this.resource = resource;

		String resourceId = null;

		ManagedAttributeInfo resourceIdAttribute = wsdmInfo.getResourceIdField();
		if(resource instanceof ManagementProxy){
			resource = ((ManagementProxy)resource).getProxiedObject();
		}
		if(resourceIdAttribute != null){
			try {
				String name = resourceIdAttribute.getName();
				if(name.length() == 1) name = name.toUpperCase();
				else name = name.substring(0,1).toUpperCase() + name.substring(1, name.length());

				Method getId = resource.getClass().getMethod("get"+name, new Class[]{});
				Object idObject = getId.invoke(resource, new Object[]{});
				resourceId = idObject.toString();
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			resourceId = SequentialResourceIDFactory.getResourceID();
		}
		this.resourceId = resourceId;
		URI uri;
		try {
			uri = getLocalAddress(WSDMBindingFactory.getDefault().getContextPath() + "/services/" + wsdmInfo.getResourceName() , WSDMBindingFactory.getDefault().getPort());
			this.setEndpointReference(new EndpointReference(uri));
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        QName name = WsaConstants.DEFAULT_RESOURCE_ID_QNAME;
        getEndpointReference().addParameter(name, resourceId);

		//Add identity capability
		ManagedAttributeInfo resourceIdField = wsdmInfo.getResourceIdField();
		SimpleIdentity identityCap;
		if(resourceIdField == null){
			identityCap = new SimpleIdentity();
			identityCap.setCapabilityURI(MuwsConstants.IDENTITY_URI);
			this.addCapability(identityCap);
		} else {
			try {
				Object value = resourceIdField.getGetter().invoke(resource, (Object[])null);
				identityCap = new IdentityImpl(value.toString());
				identityCap.setCapabilityURI(MuwsConstants.IDENTITY_URI);
				this.addCapability(identityCap);
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}

	public Element invoke(Element soapBody) {
        //
        // get WS-A action, which maps to a Capability's operation
        //
//        MessageHeaders wsa = getEnvironment().getAddressingContext();
//        String action = wsa.getAction();
//
//        System.out.println("SOAP:" + XmlUtils.toString(soapBody));
        return super.invoke(soapBody);

	}


    protected ResourcePropertyCollection createPropertyCollection()
    {
        return new DynamicResourcePropertyCollection();
    }

    public void initialize()
    throws SoapFault
{
    //Identity already added during 'complilation' phase.

	//Add description capability
//	SimpleDescription description = new SimpleDescription();
//	description.setCapabilityURI(MuwsConstants.DESCRIPTION_URI);
//	description.setResource(this);
//	description.setMessageHandlers(info.createMessageHandlers(SimpleDescription.class));
//	description.setCaption(new String[]{"Test Caption"});
//	this.addCapability(description);
	//Add MetaDataExchange
	WSDLSource metaData = new WSDLSource(wsdmInfo, resource);
//	for(ManagedOperationInfo operation : (ManagedOperationInfo[])wsdmInfo.getInfo().getOperations()){
//		if(operation.isMetaDataMethod()){
//			ManagedOperation managedOperation = (ManagedOperation)operation.getOperationMethod().getAnnotation(ManagedOperation.class);
//			metaData.addDialectHandler(managedOperation.MetaDataType(), operation.getOperationMethod());
//		}
//	}
	metaData.setCapabilityURI(WsxConstants.GET_METADATA_URI);
	metaData.setResource(this);
	metaData.setMessageHandlers(wsdmInfo.createMessageHandlers(WSDLSource.class));
	this.addCapability(metaData);
//
//	SimpleGetCapability simpleGet = new SimpleGetCapability();
//	simpleGet.setCapabilityURI(WsrpConstants.GET_CAPABILITY);
//	simpleGet.setResource(this);
//	simpleGet.setMessageHandlers(info.createMessageHandlers(SimpleGetCapability.class));
//	this.addCapability(simpleGet);
//
//	SimpleSetCapability simpleSet = new SimpleSetCapability();
//	simpleSet.setCapabilityURI(WsrpConstants.SET_CAPABILITY);
//	simpleSet.setResource(this);
//	simpleSet.setMessageHandlers(info.createMessageHandlers(SimpleSetCapability.class));
//	this.addCapability(simpleSet);

//    	SimpleQueryCapability queryCapability = new SimpleQueryCapability();
//    	queryCapability.setCapabilityURI(WsrpConstants.QUERY_RESOURCE_PROPERTIES_URI);
//    	queryCapability.setResource(this);
//    	queryCapability.setMessageHandlers(info.createMessageHandlers(SimpleQueryCapability.class));
//    	this.addCapability(queryCapability);
        	
		int dynIndex =0;

    	try{
    		ManagedResourceInfo info = wsdmInfo.getInfo();
    		
    		for(String uri : wsdmInfo.getCapabilityURIs()){
    			Class capClass = wsdmInfo.getCapabilityClass(uri);
    			Capability cap = null;
    			try {
    				Object impl = null;
    				if(capClass == wsdmInfo.getInfo().getResourceClass()){
    					impl = resource;
    				}else{
    					impl = BindingStructureHelper.instantiateCapability(uri, capClass);
    				}
    				if(impl instanceof Capability){
    					cap = (Capability) impl;
    				}else if(impl instanceof WSDMDelegator){
    					cap = (Capability)((WSDMDelegator)impl).getDelegateCapability();
    				}else{
		    			cap = new DynamicCapability();
    				}
    				if(cap instanceof DynamicBindingCapability){
    					((DynamicBindingCapability)cap).initializeBindingInfo(wsdmInfo, uri, "dyn"+dynIndex++);
    				}
    				cap.setCapabilityURI(uri);
    				cap.setResource(this);
    				cap.setMessageHandlers(wsdmInfo.createMessageHandlers(capClass));
    				this.addCapability(cap);
    			}catch(Throwable t){
					throw new RuntimeException("No Capability Implementation for " + uri);
    			}
    		}
    		
    		if(wsdmInfo.getCapabilityClass(WsnConstants.PRODUCER_URI) != null){
    			NotificationProducer notificationProducer = (NotificationProducer)getCapability(WsnConstants.PRODUCER_URI);
    			for(ManagedNotificationInfo notification : (ManagedNotificationInfo[])info.getNotifications()){
    				if(notification.isSpecNotification())continue;
    				String namespace = notification.getNamespace();
    				if("".equals(namespace)) namespace = info.getTargetNamespace();
    				String[] types = notification.getNotifTypes();
    				String topic = notification.getName();

    				if(notificationProducer.getTopicNamespace(namespace) == null)
    					notificationProducer.addTopicNamespace(namespace);
    				notificationProducer.addTopic(new QName(namespace,notification.getName()));
    			}
    		}
    		    		
//    		SimpleManageabilityCharacteristics simpleManageability = new SimpleManageabilityCharacteristics();
//    		simpleManageability.setCapabilityURI(MuwsConstants.CHARACTERISTICS_URI);
//    		simpleManageability.setResource(this);
//    		simpleManageability.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleManageabilityCharacteristics.class));
//    		this.addCapability(simpleManageability);


//    		if(info.getRelations().length > 0){
//    			SimpleRelationships relationships = new SimpleRelationships();
//    			relationships.setCapabilityURI(MuwsConstants.RELATIONSHIPS_URI);
//    			relationships.setResource(this);
//    			relationships.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleRelationships.class));
//    			this.addCapability(relationships);
//    		}

//    		if(info.getNotifications().length > 0 || info.isAdvertised()){
//    			SimpleNotificationProducer notificationProducer = new SimpleNotificationProducer();
//    			notificationProducer.setCapabilityURI(WsnConstants.PRODUCER_URI);
//    			notificationProducer.setResource(this);
//    			notificationProducer.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleNotificationProducer.class));
//    			this.addCapability(notificationProducer);
//
//    			for(ManagedNotificationInfo notification : (ManagedNotificationInfo[])info.getNotifications()){
//    				if(notification.isSpecNotification())continue;
//    				String namespace = notification.getNamespace();
//    				if("".equals(namespace)) namespace = info.getTargetNamespace();
//    				String[] types = notification.getNotifTypes();
//    				String topic = notification.getName();
//
//    				if(notificationProducer.getTopicNamespace(namespace) == null)
//    					notificationProducer.addTopicNamespace(namespace);
//    				notificationProducer.addTopic(new QName(namespace,notification.getName()));
//    			}
//
//    		}

//    		if(info.hasMetrics()){
//    			SimpleMetrics metrics = new SimpleMetrics();
//    			metrics.setCapabilityURI(MuwsConstants.METRICS_URI);
//    			metrics.setResource(this);
//    			metrics.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleMetrics.class));
//    			this.addCapability(metrics);
//    		}

    		if(info.isAdvertised()){
    			EndpointReference epr = WSDMBindingFactory.getDefault().getAdvertisementTarget(info.getAdvertisementConsumer());
    			DynamicAdvertisementCapability advertisement = (DynamicAdvertisementCapability)getCapability(MuwsConstants.ADVERTISEMENT_URI);
    			advertisement.setInitialConsumerEpr(epr);
    		}

//    		if(info.hasEventConsumers()){
//    			DynamicNotificationConsumer notificationConsumer = new DynamicNotificationConsumer(wsdmInfo);
//    			notificationConsumer.setCapabilityURI(WsnConstants.NOTIFY_URI);
//    			notificationConsumer.setResource(this);
//    			notificationConsumer.setMessageHandlers(wsdmInfo.createMessageHandlers(DynamicNotificationConsumer.class));
//    			this.addCapability(notificationConsumer);
//
//    			//TODO need to add delegate here...
//    		}
    		
//    		if(info.getAttributes().length > 0){

    		
//    			SimpleGetCapability simpleGet = new SimpleGetCapability();
//    			simpleGet.setCapabilityURI(WsrpConstants.GET_CAPABILITY);
//    			simpleGet.setResource(this);
//    			simpleGet.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleGetCapability.class));
//    			this.addCapability(simpleGet);

//    			SimpleSetCapability simpleSet = new SimpleSetCapability();
//    			simpleSet.setCapabilityURI(WsrpConstants.SET_CAPABILITY);
//    			simpleSet.setResource(this);
//    			simpleSet.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleSetCapability.class));
//    			this.addCapability(simpleSet);

//    			SimpleQueryCapability queryCapability = new SimpleQueryCapability();
//    			queryCapability.setCapabilityURI(WsrpConstants.QUERY_RESOURCE_PROPERTIES_URI);
//    			queryCapability.setResource(this);
//    			queryCapability.setMessageHandlers(wsdmInfo.createMessageHandlers(SimpleQueryCapability.class));
//    			this.addCapability(queryCapability);
//    		}

//    		DynamicCapability customCapability;
//    		String namespaces[] = wsdmInfo.getNamespaces();
//    		for(String namespace : namespaces){
//    			if(namespace.equals(MuwsConstants.OP_STATUS_URI))continue;
//    			customCapability = new DynamicCapability(info, namespace, "dyn"+dynIndex++);
//    			customCapability.setCapabilityURI(namespace);
//    			customCapability.setResource(this);
//    			this.addCapability(customCapability);
//    		}

    		_properties = createPropertyCollection();

    		//
    		// get the WSDL, which has the WS-RP definition/schema
    		//
    		WSDLSource wsdlSource = new WSDLSource(wsdmInfo, resource);
    		wsdlSource.setEnvironment(this.getEnvironment());
    		//FIXME cache this!
    		wsdl = wsdlSource.getWSDLDocument();

    		ResourcePropertiesSchema schema = createPropertiesSchema(wsdl);
    		_properties.setSchema(schema);

    		MetadataDescriptor metadata = createMetadataDescriptor(wsdl);
    		_properties.setMetadata(metadata);

    		//
    		// use parent to initialize capabilities now that WSRP model is in place
    		//
    		super.initialize();


    		_properties.applyMetadata();

//  		String validateParam = getInitializationParameter(_VALIDATE_WSRP_PARAM);

//  		//
//  		// validate WSRP schema - can be shut off with an init param flag
//  		//
//  		if (validateParam == null || validateParam.equalsIgnoreCase("true"))
//  		_properties.validateSchema();

    		_properties.validateMetadata();
    	}catch(Throwable t){
    		t.printStackTrace();
    		throw new SoapFault(t);
    	}

}

	public void shutdown() throws SoapFault {
		System.out.println("Unexpected call to shutdown");
		throw new UnsupportedOperationException();
	}


	public ResourcePropertyCollection getPropertyCollection() {
		// TODO Auto-generated method stub
		return this._properties;
	}


    /**
     *
     * @param wsdl
     *        The DOM document holding the resource's WSDL.
     *
     * @return The metadata descriptor referenced in the resource's WSDL, or
     *         an 'open' descriptor (no restrictions) if none is found.
     *
     */
    protected MetadataDescriptor createMetadataDescriptor(Document wsdl)
    {
        Element portTypeXML = WsdlUtils.getPortType(wsdl, getWsdlPortType());

        //
        // get the location of the RMD file...
        //
        String rmdName = XmlUtils.getAttribute(portTypeXML, WsrmdConstants.DESCRIPTOR_ATTR_QNAME);
        String rmdPath = XmlUtils.getAttribute(portTypeXML, WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME);

        if (rmdName == null && rmdPath == null && wsdmInfo.hasMetrics() == false)
            return OpenMetadataDescriptor.getInstance();

        if(wsdmInfo.hasMetrics()){
        	MetadataDescriptor descriptor = new DynamicMetadataDescriptor(wsdmInfo.getInfo(), wsdl.getDocumentElement());
            return descriptor;
        }

        if ((rmdName == null || rmdPath == null) && (rmdName != rmdPath))
            throw new RuntimeException(_MESSAGES.get("IncompleteMetadataAttributes"));

        //
        // load the doc and parse into a descriptor
        //
        Environment env = getEnvironment();
        String path = env.createRelativePath(getWsdlPath(), rmdPath);
        Document rmdDoc = env.getDocument(path);

        Element descriptorXML = WsrmdUtils.getMetadataDescriptor(rmdDoc, rmdName);

        if (descriptorXML == null)
        {
            Object[] filler = { rmdPath, rmdName };
            throw new RuntimeException(_MESSAGES.get("DescriptorNotFound", filler));
        }

        return new SimpleMetadataDescriptor(descriptorXML);
    }

    /**
     *
     * @param wsdl
     *        The DOM document holding the resource's WSDL.
     *
     * @return The WSRP document schema from the WSDL's <em>types</em> section,
     *         or an 'open' schema (no restrictions) if none is found.
     *
     */
    protected ResourcePropertiesSchema createPropertiesSchema(Document wsdl)
    {
        //
        // find the element that corresponds to the WS-RP name
        //
        QName wsrpName = WsrpUtils.getPropertiesName(wsdl, getWsdlPortType());
        Element wsrpDoc = WsdlUtils.getElementDeclaration(wsdl, wsrpName);

        if (wsrpDoc == null)
        {
            Object[] filler = { getContextPath(), getWsdlPath() };
            getLog().warning(_MESSAGES.get("NoWSRPDocument", filler));

            return OpenPropertiesSchema.getInstance();
        }

        return new SimpleResourcePropertiesSchema(wsrpName, wsrpDoc);
    }

	public Document getWsdlDocument() {
		return wsdl;
	}

}
