/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.SimpleResourceManager;
import org.apache.muse.core.routing.SimpleResourceRouter;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;

public class WSDMResourceRouter extends SimpleResourceRouter {
	
	public WSDMResourceRouter(){
		System.out.println("made it!");
	}
	
	
	public void initialize() throws SoapFault {
		super.initialize();
		WSDMBindingFactory.getDefault().setResourceRouter(this);
	}
	
    protected ResourceManager createResourceManager()
    {
    	ResourceManager manager = new DynamicResourceManager();
    	WSDMBindingFactory.getDefault().setResourceManager(manager);
        return manager;
    }
    	
	
	public Resource addNewResource(Resource resource, String identifier) throws SoapFault{
		ResourceManager manager = getResourceManager();
		EndpointReference epr = resource.getEndpointReference();
		epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME ,identifier);
		((SimpleResourceManager)manager).addResource(epr,resource);
		return resource;
	}
	
}
