/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl.info;

import java.lang.reflect.Method;

import javax.management.MBeanNotificationInfo;

public class WSDMNotificationInfo extends MBeanNotificationInfo {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8862834171547736839L;
	private Method payloadMethod;
	private String namespace;
	private boolean isSpecNotification;
	private String specURI;

	public WSDMNotificationInfo(String[] names, String topic, String description,
			String namespace, Method payloadMethod) throws IllegalArgumentException {
		super(names, topic, description);
		this.namespace = namespace;
		this.payloadMethod = payloadMethod;
	}
	
	public void setSpecCapabilityURI(String uri){
		this.isSpecNotification = true;
	}
	
	public String getSpecCapabilityURI(){
		return specURI;
	}
	
	public boolean isSpecNotification(){
		return isSpecNotification;
	}
	
	public String getNamespace(){
		return namespace;
	}
	
	

}
