/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.provisional.wsdm.impl.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

import org.apache.muse.ws.metadata.WsxConstants;
import org.eclipse.cosmos.me.management.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;

public class WSDMOperationInfo extends MBeanOperationInfo {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2830134962483961246L;
	private Method method;
	private static final Annotation[] EMPTY_ANNOTATION_LIST = {};
	
	//TODO continue mapping into capabilities...
	private boolean isMetaData = false;
	private boolean isOperationStatus = false;
	private boolean isState = false;
	private boolean isEventConsumer = false;
	private String namespace = "";
	private Annotation[] methodAnnotations;
	
	public Method getOperationMethod(){
		return method;
	}
	
	public boolean isMetaDataMethod(){
		return isMetaData;
	}

	public boolean isEventConsumer(){
		return isEventConsumer;
	}
	
	public String getNamespace(){
		return namespace;
	}
	
	protected <T extends Annotation> T getAnnotation(Class <T> annotation){
		for(Annotation target : methodAnnotations){
			if(target.annotationType().equals(annotation)) return (T)target;
		}
		return null;
	}

	public WSDMOperationInfo(String description, Method method, Annotation[] methodAnnotations) throws IllegalArgumentException {
		super(description, method);
		this.method = method;
		this.methodAnnotations = methodAnnotations;
		ManagedOperation managedOperation = getAnnotation(ManagedOperation.class);
		if(managedOperation != null){
			if(managedOperation.isMetaDataMethod() && 
					!WsxConstants.WSDL_DIALECT.equals(managedOperation.MetaDataType()) &&
					!"".equals(managedOperation.MetaDataType())){
				isMetaData = true;
			}
			namespace = managedOperation.namespace();
			if("".equals(namespace)){
				ManagedResourceCapability capability = getAnnotation(ManagedResourceCapability.class);
				if(capability != null) namespace = capability.namespace();
			}
		}
		ManagedEventConsumer eventConsumer = getAnnotation(ManagedEventConsumer.class);
		if(eventConsumer != null){
			isEventConsumer = true;
		}
	}
	
	public Annotation[] getAnnotationsForParameter(MBeanParameterInfo info){
		MBeanParameterInfo[] parms = getSignature();
		if(parms == null) return EMPTY_ANNOTATION_LIST;
		int i = 0;
		for(MBeanParameterInfo parm: parms){
			if(parm.equals(info)) break;
			i++;
		}
		if(i < parms.length){
			//FIXME - this could cause some problems for overridden methods
			Annotation[][] annotations = method.getParameterAnnotations();
			return annotations[i];
		}
		return EMPTY_ANNOTATION_LIST;
	}

}
