package org.eclipse.cosmos.me.management.provisional.wsdm.util;

import java.util.ArrayList;
import java.util.Hashtable;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Element;

public class RelationshipHelper {
	
	public static ArrayList getRelationships(WsResourceClient _resource) throws Exception{
		ArrayList relationships = new ArrayList();

		String resourceType = "RelationshipResource";
		boolean isRelationshipResource = true;
		Element ele = _resource.getResourcePropertyDocument();
		System.out.println(XmlUtils.toString(ele));
		
		// first check to see if this is a resource with relationships
		
		Element rels[] = _resource.getResourceProperty(MuwsConstants.RELATIONSHIP_QNAME);
		if(rels!=null && rels.length>0){
			resourceType = "ResourceWithRelationships";
			isRelationshipResource = false;
		}

		relationships.add(resourceType);
		if(!isRelationshipResource){
			for(int i=0; i<rels.length; i++){
				relationships.add(createRelationship(rels[i]));
			}
		}
		
		return relationships;
	}
	
	protected static Hashtable createRelationship(Element el){
		Hashtable table = new Hashtable();
		Element nameElement = XmlUtils.findFirstInSubTree(el, MuwsConstants.NAME_QNAME);
		if(nameElement!=null){
			String name = XmlUtils.extractText(nameElement);
			table.put("name",name);
		}
		Element typeElement = XmlUtils.findFirstInSubTree(el, MuwsConstants.TYPE_QNAME);
		if(typeElement!=null){
			String type = XmlUtils.toString(typeElement);
			table.put("type",type);
		}
		
		Hashtable participants = new Hashtable();
		table.put("participants", participants);
		Element pElements[] = XmlUtils.findInSubTree(el, MuwsConstants.PARTICIPANT_QNAME);
		if(pElements!=null){
			for(int i=0; i<pElements.length; i++){
				addParticipant(participants, pElements[i]);
			}
		}
		return table;
	}
	
	protected static void addParticipant(Hashtable participants, Element el){
		Hashtable partiDetails = new Hashtable();
		Element roleElement = XmlUtils.findFirstInSubTree(el, MuwsConstants.ROLE_QNAME);
		String role = XmlUtils.extractText(roleElement);
		
		Element eprElement = XmlUtils.findFirstInSubTree(el, MuwsConstants.MANAGEABILITY_EPR_QNAME);
		String epr = XmlUtils.toString(eprElement);
		Element element = (Element) XmlUtils.getElement(eprElement,WsaConstants.ADDRESS_QNAME);
		String uri = XmlUtils.extractText(element);
		partiDetails.put("epr", epr);
		partiDetails.put("displayString", uri);
		partiDetails.put("ManagedAgentType", "WSDM");

		participants.put(role, partiDetails);
	}
}
