package org.eclipse.cosmos.me.management.provisional.wsrf.capabilities;

import java.util.Date;

import org.eclipse.cosmos.me.management.provisional.wsrf.faults.TerminationTimeChangeRejectedFault;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.UnableToSetTerminationTimeFault;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedPropertyGetter;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMResourceCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMSchemaImport;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.BaseFault;

@WSDMResourceCapability
@ManagedResourceCapability(namespace = "http://docs.oasis-open.org/wsrf/rpw-2/Get")
public interface ScheduledTerminationCapability {
	
	@WSDMSchemaImport(location="WS-ResourceProperties-1_2.xsd")
	public static String WSRF_RESOURCE_PROPERTIES_NAMESPACE = "http://docs.oasis-open.org/wsrf/rp-2"; 

	@WSDMSchemaImport(location="WS-Resource-1_2.xsd")
	public static String WSRF_RESOURCE_NAMESPACE = "http://docs.oasis-open.org/wsrf/r-2"; 

	@ManagedPropertyGetter
    Date getCurrentTime() 
        throws BaseFault;
    
	@ManagedPropertyGetter
	Date getTerminationTime() 
        throws BaseFault;
    
	@ManagedOperation
    Date setTerminationTime(Date time) 
        throws UnableToSetTerminationTimeFault, 
               TerminationTimeChangeRejectedFault;
}
