package org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.impl;

import javax.xml.namespace.QName;

import org.apache.muse.core.Capability;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.properties.get.faults.InvalidResourcePropertyQNameFault;
import org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.GetCapability;

public class GetCapabilityImpl implements GetCapability, WSDMDelegator  {
	
	
	private SimpleGetCapability delegateCapability = new SimpleGetCapability(); 
	
	@ManagedFrameworkAutowire(name = "$RESOURCE")
	Object resource;
	
	public void setResource(Object resource){
		this.resource = resource;
	}
	
	@ManagedFrameworkAutowire(name="WSDM")
	private Binding wsdmBinding;
	
	public void setWsdmBinding(Binding wsdmBinding){
		this.wsdmBinding = wsdmBinding;
	}
	
	public Object[] getMultipleResourceProperties(QName[] qnames) {
		// TODO Auto-generated method stub
		try {
			delegateCapability.getMultipleResourceProperties(qnames);
		} catch (InvalidResourcePropertyQNameFault e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BaseFault e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	public Object getResourcePropertyDocument() {
		// TODO Auto-generated method stub
		return null;
	}

	public Object[] getResourceProperty(QName qname) {
		return null;
	}

	public Capability getDelegateCapability() {
		return delegateCapability;
	}

}
