package org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.impl;

import org.apache.muse.core.Capability;
import org.apache.muse.ws.resource.lifetime.impl.SimpleImmediateTermination;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.provisional.wsdm.WSDMDelegator;
import org.eclipse.cosmos.me.management.provisional.wsrf.capabilities.ImmediateTerminationCapability;
import org.eclipse.cosmos.me.management.provisional.wsrf.faults.ResourceNotDestroyedFault;

public class ImmediateTerminationCapabilityImpl implements ImmediateTerminationCapability, WSDMDelegator  {
	
	
	private SimpleImmediateTermination delegateCapability = new SimpleImmediateTermination(); 
	
	@ManagedFrameworkAutowire(name = "$RESOURCE")
	Object resource;
	
	public void setResource(Object resource){
		this.resource = resource;
	}
	
	@ManagedFrameworkAutowire(name="WSDM")
	private Binding wsdmBinding;
	
	public void setWsdmBinding(Binding wsdmBinding){
		this.wsdmBinding = wsdmBinding;
	}
	
	public Capability getDelegateCapability() {
		return delegateCapability;
	}

	public void destroy() throws ResourceNotDestroyedFault {
		// TODO Auto-generated method stub
		
	}

}
