/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.wsdm.osgi;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator implements BundleActivator {

	private BundleContext context;

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		//Listen for WSDM service
		setBundleRootLocation(context);

		OSGiWSDMBindingFactory.setBundle(context.getBundle());

		this.context = context;

	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}

	private void setBundleRootLocation(BundleContext context) throws BundleException {
		String prop = System.getProperty("data.location");
		String dir = System.getProperty("user.dir");
		Properties props = System.getProperties();
		File root = null;
		if(prop == null){
			Bundle bundles[] = context.getBundles();
			for(int i=0;i<bundles.length;i++){
				if("org.eclipse.equinox.common".equals(bundles[i].getSymbolicName())){
					if(Bundle.ACTIVE != bundles[i].getState()){
						//Allow the exception to propogate - we're no good without the location
						bundles[i].start();
					}
				}
			}
			try {
				root = new File(FileLocator.resolve(context.getBundle().getEntry("/")).getFile());
			} catch (IOException e) {
				throw new BundleException("Initialization Error", e);
			}
		} else if("USE_BUNDLE_DATA".equals(prop)){
			root = context.getDataFile(".");
		} else {
			root = new File(prop);
		}
		BundleRootHelper.registerRoot(context.getBundle(), root);

	}

}
