/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.wsdm.osgi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.WeakHashMap;

import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.routing.OSGiResourceRouter;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.dm.muws.events.WefFactory;
import org.apache.muse.ws.dm.muws.events.impl.SimpleWefFactory;
import org.apache.muse.ws.resource.WsResource;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBinding;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBindingFactory;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBindingUtil;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMNotificationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMRelationInfo;
import org.eclipse.cosmos.me.management.provisional.wsdm.util.SchemaHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.w3c.dom.Document;

public class OSGiWSDMBindingFactory extends WSDMBindingFactory implements ServiceFactory {

	protected static WSDMBindingFactory createInstance(){
		return new OSGiWSDMBindingFactory();
	}
	
	private static Bundle _bundle;
	private ResourceManagementProvider _wsdmProvider;

	public static void setBundle(Bundle bundle){
		_bundle = bundle;
	}

	public static WSDMBindingFactory getDefault(){
		if(_default == null) _default = createInstance();
		return _default;
	}

	public void setWSDMProvider(ResourceManagementProvider wsdmProvider){
		((OSGiWSDMBindingFactory)_default)._wsdmProvider = _wsdmProvider;
		_wsdmProvider = wsdmProvider;
	}

	public void postProcessRegistration(WSDMBinding binding){
		OSGiResourceRouter.getDefault().setDelegateBundle(_bundle, "cosmos", binding.getContextPath().substring(1));
	}

	public Object getService(Bundle bundle, ServiceRegistration registration) {
		return getDefault();
	}

	public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
	}


	protected static void loadAdvertisementTargets(){
		Enumeration entries = _bundle.findEntries("/OSGI-INF/Advertisement", "*.*", true);
		if(entries != null){
			while(entries.hasMoreElements()){
				URL obj = (URL)entries.nextElement();
				System.out.println("Entry " + obj);
				String value = obj.toString();
				int location = value.indexOf("/OSGI-INF/Advertisement");
				value = value.substring(location+24); //length of /OSGI-INF/Advertisement + 1
				location = value.lastIndexOf(".");
				if(location == -1){
					value = value;
				}else{
					value = value.substring(0,location);
				}
				try{
					InputStream stream = obj.openStream();
					Document doc = XmlUtils.createDocument(stream);
					EndpointReference ref = new EndpointReference(doc.getDocumentElement());
					System.out.println("Ref is " + ref);
					advertisementMap.put(value,ref);
				}catch(Throwable t){
					t.printStackTrace();
				}
			}
		}
	}

}
