package org.eclipse.cosmos.me.management.wsdm.web;

import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;

import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.sg.remote.ServiceGroupClient;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.BindingProvider;
import org.eclipse.cosmos.me.management.common.StatusChangeListener;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBindingFactory;
import org.eclipse.cosmos.me.management.web.ContributionManagerImpl;

public class WSDMServiceInitializer implements ServletContextListener, BindingProvider {

	private ArrayList<Binding> bindingSet = new ArrayList<Binding>();
	
	private ContributionManagerImpl cosmosManager;
	
	protected ContributionManagerImpl getManager(){
		return cosmosManager;
	}
		
	public void contextDestroyed(ServletContextEvent event) {
	}
	

	public void contextInitialized(ServletContextEvent event) {
		//Bootstrap Muse
		final ServletContext context = event.getServletContext();
		Enumeration attrNames = context.getAttributeNames();
		while(attrNames.hasMoreElements()){
			String name = (String)attrNames.nextElement();
			System.out.println(name + " " + context.getAttribute(name));
		}
		
		Thread kickstartThread = new Thread(new Runnable() {
			public void run() {
				launchWarmUpMuse(context);
			}
		});
		kickstartThread.start();
		
	}
	
	//To be overridden
	protected void managerInitialized(){
		
	}

	public Collection<Binding> getBindings() {
		return bindingSet;
	}
	
	
	private void launchWarmUpMuse(final ServletContext context){
			try {
				Thread.currentThread().sleep(5000);
			} catch (InterruptedException e1) {
			}
		Thread museThread = new Thread(new Runnable() {
			public void run() {
				warmUpMuse(context.getServletContextName());
			}
		});
		museThread.start();
		try {
			museThread.join();
		} catch (InterruptedException e) {}
		
    	bindingSet.add(WebWSDMBindingFactory.getDefault());
    	cosmosManager = ContributionManagerImpl.getDefault();
    	cosmosManager.initialize(this);
    	WebWSDMBindingFactory.getDefault().setResourceRouter(ResourceRouter.getRouterInstance());
    	WebWSDMBindingFactory.getDefault().setResourceManager(ResourceRouter.getRouterInstance().getResourceManager());
    	WebWSDMBindingFactory.getDefault().setContextPath(context.getServletContextName());
    	String portParam = context.getInitParameter("CosmosWebPort");
    	if(portParam != null) WebWSDMBindingFactory.getDefault().setPort(portParam);
    	managerInitialized();
		
	}
	
	private void warmUpMuse(String contextName){
		/*
		 * Warm up Muse...
		 */
        try
        {
            //
            // change these to point to different applications/servers
            //
            String webAppRoot = "/" + contextName;
            String contextPath = webAppRoot + "/services/Relationships";
            String port = System.getProperty("org.eclipse.cosmos.me.web.bootstrap.port", "8080");

            //
            // test WSSG directory
            //
            String ip = InetAddress.getLocalHost().getHostAddress();

            StringBuffer address = new StringBuffer();
            address.append("http://");
            address.append(ip);
            address.append(':');
            address.append(port);

            if (contextPath.charAt(0) != '/')
                address.append('/');

            address.append(contextPath);

            URI addressURI = URI.create(address.toString());


            EndpointReference epr = new EndpointReference(addressURI);

            ServiceGroupClient sg = new ServiceGroupClient(epr);

            //
            // ping SG, wait a few seconds, then check for members
            // that were added by the simulation factory
            //
            System.out.println("Pinging Muse to initialize the endpoint...");
            sg.getResourcePropertyDocument();
            System.out.println("Waiting 10 seconds while simulation creates WS-resources...");
        }catch(SoapFault s){
        	//We're expecting a "Destination Unreachable" error here...
        	if(!WsaConstants.DESTINATION_UNREACHABLE_FAULT_QNAME.equals(s.getSubCode())){
        		s.printStackTrace();
        	}
        }catch(Throwable t){
        	t.printStackTrace();
        }finally{
        	WebWSDMBindingFactory.getDefault().statusChanged(WebWSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
        }

	}
	

}
