/*******************************************************************************
 * Copyright (c) 2008 Computer Associates.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Computer Associates - initial implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.stat.datamgr;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;

import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.dataManager.impl.AbstractDataManager;
import org.eclipse.cosmos.dc.stat.datamgr.api.IStat;
import org.eclipse.cosmos.dc.stat.datamgr.common.DataSourceKeyset;
import org.eclipse.cosmos.me.management.annotations.ManagedResource;
import org.w3c.dom.Element;

@ManagedResource
public class StatisticalDataManager extends AbstractDataManager implements IDataManager, IStat {

	private int _dset_id;
	private int _kset_id;
	
	public String[] getDatasourceKeysets() throws CosmosException 
	{
		Connection conn = null;
		Vector<String> vn = null;
		Vector<Integer> vid = null;
		Vector<DataSourceKeyset> kn = null;
		Iterator Iv = null;
		Iterator Ik = null;
		String v = null;
		String k = null;
		String[] ret = null;
		int idx = 0;
		DataSourceKeyset ds = null;
		
		vn = new Vector<String>();
		vid = new Vector<Integer>();
		kn = new Vector<DataSourceKeyset>();
		conn = getConnection();
		if (conn == null)
			return null;

		fillInDataSets(conn,vn,vid);
		fillInKeySets(conn,vn,vid,kn);

		ret = new String[kn.size() * 2];
		Ik = kn.iterator();
		while (Ik.hasNext()) {
			ds = (DataSourceKeyset) Ik.next();
			v = ds.getDataSet();
			k = ds.getKeySet();
			ret[idx++] = v;
			ret[idx++] = k;
		}
		return ret;
	}
	
	public void fillInKeySets(Connection conn,Vector<String> vn,Vector<Integer> vid,Vector<DataSourceKeyset> kn)
	{
		ResultSet rs = null;
		Statement stmt = null;
		String query = null;
		Iterator It = null;
		Iterator Itv = null;
		Iterator Itk = null;
		Integer itmp = null;
		int ivalue = 0;
		Vector<Integer> kid = null;
		int id = 0;
		String s = null;
		Integer I = null;
		DataSourceKeyset ds = null;
		String v = null;
				
		It = vid.iterator();
		Itv = vn.iterator();
		while (It.hasNext()) {
			itmp = (Integer) It.next();
			ivalue = itmp.intValue();
			v = (String) Itv.next();
			
			query = new String("select KEY_ENTRY from COSMOS_STAT.STATISTICAL_OBSERVATION where DATA_SET_ID = " + ivalue);
		
			rs = DoQuery(conn,query);
			
			kid = new Vector<Integer>();
			try {
				while (rs.next()) {
					id = rs.getInt("KEY_ENTRY");
					id = Translate(conn,id);
					I = new Integer(id);
					if (!kid.contains(I))
						kid.add(I);
				}
			} catch (Exception e) {
				System.out.println("Could not get keyset entry " + e.getMessage());
				return;
			}
		
			Itk = kid.iterator();
			while (Itk.hasNext()) {
				itmp = (Integer) Itk.next();
				ivalue = itmp.intValue();
				s = getKeySetName(conn,ivalue);
				ds = new DataSourceKeyset(v,s);
				kn.add(ds);
			}
		}
	}

	public void fillInDataSets(Connection conn,Vector<String> vn,Vector<Integer> vid)
	{
		ResultSet rs = null;
		Statement stmt = null;
		String query = new String("select * from COSMOS_STAT.STATISTICAL_DATASET");
		
		rs = DoQuery(conn,query);
				
		try { 
			while (rs.next()) {
				String name = rs.getString("NAME");
				if (name == null)
					name = new String("<NULL>");
				vn.add(name);
				int id = rs.getInt("ID");
				Integer I = new Integer(id);
				vid.add(I);
			}
		} catch (Exception ex) {
			System.out.println("Retrival error: " + ex.getMessage());
			return;
		}
		try {
			if (stmt != null)
				stmt.close();
			if (rs != null)
				rs.close();
		} catch(Exception ex2) { 
			System.out.println("EEK!");
			return;
		}
	}
	
	public Element getStatDataForSources(String dataset, String keyset, int start, int size) throws CosmosException
	{
		Connection conn = null;
		_dset_id = 0;
		_kset_id = 0;
		
		conn = getConnection();
		if (conn == null)
			return null;
		
		SetDSetId(dataset);
		SetKSetId(keyset);
		return DoObservation(conn,start,size);
	}

	private int Translate(Connection conn,int id)
	{
		ResultSet rs = null;
		String query = new String("select KEYSET from COSMOS.KEY_SET_ENTRY where ID = " + id);
		int ret = 0;
		
		rs = DoQuery(conn,query);
		
		try {
			rs.next();
			ret = rs.getInt("KEYSET");
		} catch (Exception e) {
			System.out.println("Couldn't get ID");
			return 0;
		}
		return ret;
	}
	private String getKeySetName(Connection conn,int id) {
		ResultSet rs = null;
		String ret = null;
		
		String query = new String("select NAME from COSMOS.KEY_SET where ID = " + id);
		
		rs = DoQuery(conn,query);
		
		try {
			rs.next();
			ret = rs.getString("NAME");
		} catch (Exception e) {
			System.out.println("Couldn't get ID");
			return null;
		}
		return ret;
	}
	private void SetKSetId(String lookup) throws CosmosException
	{
		Connection conn= null;
		Statement stmt;
		ResultSet rs = null;
		String query = null;
		
		conn = getConnection();
		if (conn == null)
			return;

		query = new String("select ID from COSMOS.KEY_SET where NAME = '" + lookup + "'");
		rs = DoQuery(conn,query);
				
		try {
			rs.next();
			_kset_id = rs.getInt("ID");
		} catch (Exception e) {
			System.out.println("Couldn't get ID");
		}
	}
	
	private void SetDSetId(String lookup) throws CosmosException
	{
		Connection conn= null;
		Statement stmt;
		ResultSet rs = null;
		String query = null;
		
		conn = getConnection();
		if (conn == null)
			return;

		query = new String("select ID from COSMOS_STAT.STATISTICAL_DATASET where NAME = '" + lookup + "'");
		rs = DoQuery(conn,query);
	
		try {
			rs.next();
			_dset_id = rs.getInt("ID");
		} catch (Exception e) {
			System.out.println("Couldn't get ID");
		}
	}
	
	private Connection getConnection(){       
		Connection conn = null;
		Object [] urlArgs = { "dummy" }; 
		String url = MessageFormat.format("jdbc:derby:cosmosdb;create=true", (Object[])urlArgs);
		Driver d = null;

		System.out.println("derby " + System.getProperty("derby.system.home"));
		try {
			d = (Driver) Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
			DriverManager.registerDriver(d);
 
			conn = DriverManager.getConnection( url);
				
			DriverManager.deregisterDriver(d);
 	
		} catch (Exception ex) {
			System.out.println( "failed to connect to " + url );
			System.out.println( "exception = " + ex.getMessage() );
			return null;
		} 

		System.out.println( "connected to " + url );

		return conn;
	}	

	private Element DoObservation(Connection conn,int start,int size) {
		ResultSet rs = null;
		Statement stmt = null;
		Element ret = null;
		String query = null;
		int cnt = 0;
		int idx = 0;
		long l = 0;
		
		query = new String("select * from COSMOS_STAT.STATISTICAL_OBSERVATION where DATA_SET_ID = " + _dset_id + " and KEY_ENTRY = " + _kset_id);
		rs = DoQuery(conn,query);
		
		ret = XmlUtils.createElement(IStat.GET_STAT_OBSERVATIONS_QNAME);
	
		try { 
			while (rs.next()) {
				if (idx >= start) {
					Element el = XmlUtils.createElement(IStat.GET_STAT_OBSERVATION_QNAME);
				
					Timestamp d = rs.getTimestamp("CAPTURE_TIME");
					Element dt = XmlUtils.createElement(IStat.GET_STAT_DATE_QNAME);
					dt.setTextContent(d.toString());
					el.appendChild(dt);
				
					String svalue = rs.getString("STRING_VALUE");
					if (svalue == null)
						svalue = new String("<NULL>");
				
					Element str = XmlUtils.createElement(IStat.GET_STAT_STRING_QNAME);
					str.setTextContent( svalue);
					el.appendChild( str );

					Element ivalue = XmlUtils.createElement(IStat.GET_STAT_INTEGER_QNAME);
					l = rs.getLong("INTEGRAL_VALUE");
					ivalue.setTextContent( String.valueOf(l));
					el.appendChild( ivalue );
										
					Element dvalue = XmlUtils.createElement(IStat.GET_STAT_DOUBLE_QNAME);
					dvalue.setTextContent( String.valueOf(rs.getDouble("DECIMAL_VALUE")));
					el.appendChild( dvalue );
		
					ret.appendChild(el);
					cnt++;
				}
				idx++;
				if (cnt == size)
					break;
			}
		} catch (Exception ex) {
			System.out.println("Retrival error: " + ex.getMessage());
		}
		try {
		if (stmt != null)
			stmt.close();
		if (rs != null)
			rs.close();
		} catch(Exception ex2) { 
			System.out.println("EEK!");
		}
		return ret;
	}

	private ResultSet DoQuery(Connection conn,String query) {
		Statement stmt = null;
		ResultSet ret = null;
	
		System.out.println("Trying query " + query);
		try {
			stmt = conn.createStatement();
			ret = stmt.executeQuery(query);
		} catch (Exception e) {
			System.out.println("Select error: " + e.getMessage());
			return null;
		}
		System.out.println("ok " + query);

		return ret;
	}
}
