/*******************************************************************************
 * Copyright (c) 2008 Computer Associates.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Computer Associates - initial implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.stat.datamgr.client;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

import javax.xml.namespace.QName;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.dataManager.client.DataManagerClient;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.stat.datamgr.api.IStat;
import org.eclipse.cosmos.dc.stat.datamgr.client.IStatisticalClient;
import org.eclipse.cosmos.dc.stat.datamgr.common.DataSourceKeyset;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatisticalDataManagerClient extends DataManagerClient implements IStatisticalClient, IStat {

	private String _name = null;
	
	public StatisticalDataManagerClient()
	{
		super(null);
	}
	
	public StatisticalDataManagerClient(EndpointReference epr)
	{
		super(epr);
	}
	
	/*
	 * client interface
	 */
	
	public Collection<DataSourceKeyset> getDatasourceKeyset() throws CosmosException 
	{
		Vector<DataSourceKeyset> ret = null;
		String[] strs = null;
		int i = 0;
		String d = null;
		String k = null;
		DataSourceKeyset tmp = null;
		
		ret = new Vector<DataSourceKeyset>();
		
		strs = getDatasourceKeysets();
		for (i=0;i<strs.length;i++) {
			d = strs[i++];
			k = strs[i];
			tmp = new DataSourceKeyset(d,k);
			ret.add(tmp);
		}
		return ret;
	}

	/*
	 * client interface
	 */

	public Collection<StatisticalTuple> getStatDataForSource(String dataset, String keyset, int start, int size) throws CosmosException
	{
		Collection<StatisticalTuple> ret = null;
		Element e = null;
		Iterator I = null;
		StatisticalTuple t = null;
		
		_name = new String(dataset);
		ret = new Vector<StatisticalTuple>();
		
		e = getStatDataForSources(dataset,keyset,start,size);
				
		ret = MakeTuples(e);
		
		return ret;
	}
	
	/* 
	 * web service interface
	 */
	
	public Element getStatDataForSources(String dataset, String keyset, int start, int size) throws CosmosException
	{
		QName q = IStat.GET_STAT_OP_QNAME;
		String op = IStat.GET_STAT_OP_URI;
		Element ds = null;
		Element dk = null;
		Element st = null;
		Element sz = null;
		Element e = null;
		QName tq = null;
		
		tq = new QName(IStat.NAMESPACE_URI, "dataset", PREFIX);
		ds = XmlUtils.createElement(tq);
		ds.setTextContent(dataset);

		tq = new QName(IStat.NAMESPACE_URI, "keyset", PREFIX);
		dk = XmlUtils.createElement(tq);
		dk.setTextContent(keyset);
		
		tq = new QName(IStat.NAMESPACE_URI, "start", PREFIX);
		st = XmlUtils.createElement(tq);
		st.setTextContent(String.valueOf(start));
		
		tq = new QName(IStat.NAMESPACE_URI, "size", PREFIX);
		sz = XmlUtils.createElement(tq);
		sz.setTextContent(String.valueOf(size));
		
		//setTrace(true);
		try {
			e = SendRequest(op,q,ds,dk,st,sz);
		} catch (DataManagerException ex) {
			throw new CosmosException("Problem sending request",ex);
		}
		
		return e;
	}

	/* 
	 * web service interface
	 */
	
	public String[] getDatasourceKeysets() throws CosmosException {
		QName q = IStat.GET_KEYSET_OP_QNAME;
		String op = IStat.GET_KEYSET_OP_URI;
		Element e = null;
		String[] ret = null;
		
		//setTrace(true);
		try {
			e = SendRequest(op,q,null,null,null,null);
		} catch (DataManagerException ex) {
			throw new CosmosException("Problem sending request",ex);
		}
		
		ret = ProcessLF(e);
		return ret;
	}

	private String[] ProcessLF(Element e) {
		NodeList n = null;
		Element el = null;
		int i = 0;
		String s = null;
		String r = null;
		String[] p = null;
		String[] ret = null;
		int idx = 0;
		
		n = e.getElementsByTagName("dyn:getDatasourceKeysetsResponseType");	
		if (n.getLength() > 0) 
			p = new String[n.getLength()];
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				s = XmlUtils.extractText(el);
				if (s.length() > 0) 
					p[idx++] = new String(s);
			}
		}
		ret = new String[idx];
		for (i=0;i<idx;i++)
			ret[i] = new String(p[i]);
		return ret;
	}
	private Element SendRequest(String operation,QName qstr,
				Element ds,
				Element ks,
				Element st,
				Element sz) throws DataManagerException
	{
		Element soapBody = XmlUtils.createElement(qstr);
				
		if (ds != null) {
			Element parm = XmlUtils.createElement(IStat.GET_STAT_DATASET_QNAME);
			parm.appendChild(ds);
			soapBody.appendChild(ds);
		}
		if (ks != null) {
			Element parm = XmlUtils.createElement(IStat.GET_STAT_KEYSET_QNAME);
			parm.appendChild(ks);
			soapBody.appendChild(ks);
		}
		if (st != null) {
			Element parm = XmlUtils.createElement(IStat.GET_STAT_START_QNAME);
			parm.appendChild(st);
			soapBody.appendChild(st);
		}
		if (sz != null) {
			Element parm = XmlUtils.createElement(IStat.GET_STAT_SIZE_QNAME);
			parm.appendChild(sz);
			soapBody.appendChild(sz);
		}
		//setTrace(true);
		try {
			Element results = invoke(operation, soapBody);
			return results;
		} catch (SoapFault e) {
			throw new DataManagerException(e);
		}
	}

	private Collection<StatisticalTuple> MakeTuples(Element e) {
		Vector<StatisticalTuple> ret = null;
		Date d = null;
		NodeList n = null;
		int i = 0;
		Element el = null;
		StatisticalObservation ob = null;
		Date od = null;
		Date cd = null;
		StatisticalTuple t = null;
		
		ret = new Vector<StatisticalTuple>();
		n = e.getElementsByTagName("stat:observation");	
		//System.out.println("Num " + n.getLength());
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				ob = MakeStatObj(el);
				od = GetDate(el);
				if (od == null)
					return null;
				if (cd == null) {
					t = new StatisticalTuple();
					t.setTimeStamp(od);
					t.add(ob);
					ret.add(t);
				} else {
					if (od.equals(cd))
						t.add(ob);
					else {
						t = new StatisticalTuple();
						t.setTimeStamp(od);
						t.add(ob);
						ret.add(t);
					}
				}
				cd = od;
			}
		}
		return ret;
	}
	
	private Date GetDate(Element e)
	{
		NodeList n = null;
		Date ret = null;
		int i = 0;
		String s = null;
		Element el = null;
		
		n = e.getElementsByTagName("stat:date");	
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				s = XmlUtils.extractText(el);
				try {
					System.out.println("S = " + s);
					SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
					ret = sd.parse(s);
				} catch(Exception ex) {
					System.out.println("Invalid date " + s);
					System.out.println(ex.getMessage());
					return null;
				}
			}
		}
		
		return ret;
	}
	private StatisticalObservation MakeStatObj(Element e) {
		NodeList n = null;
		int i = 0;
		Element el;
		String str = null;
		String s = null;
		Long ivalue = null;
		Double dvalue = null;
		StatisticalObservation ret = null;
		Object obj = null;
		
		n = e.getElementsByTagName("stat:string");	
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				str = XmlUtils.extractText(el);
				if (!str.equals("<NULL>"))
					obj = str;
			}
		}
		
		n = e.getElementsByTagName("stat:integer");	
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				s = XmlUtils.extractText(el);
				ivalue = Long.valueOf(s);
				if ((obj == null) && (ivalue.longValue() != 0))
					obj = ivalue;
			}
		}

		n = e.getElementsByTagName("stat:double");	
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				s = XmlUtils.extractText(el);
				dvalue = Double.valueOf(s);
				if ((obj == null) && (dvalue.doubleValue() != 0))
					obj = dvalue;
			}
		}
		
		ret = new StatisticalObservation(_name,obj);
		
		return ret;
	}
}