/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.sample.cmdbf.services.metadata;

import java.io.BufferedInputStream;
import java.io.IOException;

import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IServiceDescription;

/**
 * An abstract class shared between the query
 * and registration metadata class
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractServiceMetadata
{
	/**
	 * Constructs and returns a service description
	 * 
	 * @param factory The factory that is used to create a service
	 * description object
	 * @return A service description
	 */
	protected IServiceDescription constructServiceDescription(IMetadataArtifactFactory factory)
	{
		IServiceDescription serviceDescription = factory.createServiceDescription();
		serviceDescription.setMdrId("http://sample.mdr");
		serviceDescription.setDescription("Sample MDR");		
		
		return serviceDescription;
	}

	
	/**
	 * Prints the stream that is passed in
	 *  
	 * @param bufferedInputStream The stream to be printed
	 * @throws IOException In case of an IO error
	 */
	public void printStream(BufferedInputStream bufferedInputStream) throws IOException
	{
		byte[] buffer = new byte[1024];
		while (bufferedInputStream.available() > 0)
		{
			int length = bufferedInputStream.read(buffer);
			System.out.print(new String(buffer, 0, length));
		}
	}
}
