/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.sample.cmdbf.services.metadata;

import java.io.BufferedInputStream;
import java.io.IOException;

import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.QueryMetadataTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IContentSelectorSupport;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IQueryCapabilities;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IQueryServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.MetadataArtifactFactory;

/**
 * Metadata for the query service 
 * 
 * @author Ali Mehregani
 */
public class QueryMetadataLauncher extends AbstractServiceMetadata
{
	public static void main (String[] args) throws IOException
	{
		new QueryMetadataLauncher().printMetadata();
	}
	
	public void printMetadata() throws IOException
	{
		// Create the factory class
		IMetadataArtifactFactory factory = MetadataArtifactFactory.getInstance();
		
		// Create the root object along with the query capability object
		IQueryServiceMetadata queryServiceMetadata = factory.createQueryServiceMetadata();
		IQueryCapabilities queryCapabilities = factory.createQueryCapabilities();
		queryServiceMetadata.setQueryCapabilities(queryCapabilities);
		
		// Set the service description
		queryServiceMetadata.setServiceDescription(constructServiceDescription(factory));
		
		// Create the content selector support object and set record type to true
		IContentSelectorSupport contentSelectorSupport = factory.createContentSelectorSupport();
		contentSelectorSupport.setRecordTypeSelector(true);
		queryCapabilities.setContentSelectorSupport(contentSelectorSupport);		
		
		// Output the result
		printStream(new BufferedInputStream (QueryMetadataTransformer.transform(queryServiceMetadata)));		
	}
}
