/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.sample.cmdbf.services.metadata;

import java.io.BufferedInputStream;
import java.io.IOException;

import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.RegistrationMetadataTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordTypeList;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRegistrationServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.MetadataArtifactFactory;

/**
 * Metadata for the registration service 
 * 
 * @author Ali Mehregani
 */
public class RegistrationMetadataLauncher extends AbstractServiceMetadata
{
	public static void main (String[] args) throws IOException
	{
		new RegistrationMetadataLauncher().printMetadata();
	}
	
	public void printMetadata() throws IOException
	{
		// Create the factory class
		IMetadataArtifactFactory factory = MetadataArtifactFactory.getInstance();
		
		// Create the root object along with the query capability object
		IRegistrationServiceMetadata registrationServiceMetadata = factory.createRegistrationServiceMetadata();
				
		// Set the service description
		registrationServiceMetadata.setServiceDescription(constructServiceDescription(factory));
		
		// Add the supported record types
		IRecordTypeList recordTypeList = factory.createRecordTypeList();
		registrationServiceMetadata.setRecordTypeList(recordTypeList);
		IRecordTypes recordTypes = factory.createRecordTypes();
		recordTypeList.addRecordTypes(recordTypes);
		recordTypes.setNamespace("");
		
		String[] supportedRecords = new String[] {"student", "teacher", "class"};		
		for (int i = 0; i < supportedRecords.length; i++)
		{
			IRecordType recordType = factory.createRecordType();
			recordType.setLocalName(supportedRecords[i]);
			recordTypes.addRecordType(recordType);
		}
						
		// Output the result
		printStream(new BufferedInputStream (RegistrationMetadataTransformer.transform(registrationServiceMetadata)));
	}

}
