/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

import org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.impl.CMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.DeregistrationOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.DeregisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.registration.service.impl.CMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.RegistrationOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.RegisterOutputArtifactFactory;

/**
 * An abstract service launcher used for the registration
 * and deregistration launchers
 */
public abstract class AbstractServiceLauncher
{
	/**
	 * Executes the operation
	 * 
	 * @param type The type of the operation (i.e. {@link INotificationHandler#REGISTRATION}
	 * or {@link INotificationHandler#DEREGISTRATION}.
	 * @param input The file containing the request
	 * @param supportedRecords The supported record types
	 * @throws IOException In case of an error
	 * @throws CMDBfServiceException 
	 */
	public void executeOperation (int type, String input, String[][] supportedRecords) throws IOException, CMDBfServiceException
	{
		// Initialization data
		Map<String, Object> init = new Hashtable<String, Object>();
		init.put(ISampleCMDBfOperationConstants.SUPPORTED_TYPES, supportedRecords);
		
		// Create and execute the operation
		AbstractNotificationOperation operation = type == INotificationHandler.REGISTRATION ? 
				new CMDBfRegistrationOperation(SampleNotificationHandlerFactory.getInstance(), RegisterOutputArtifactFactory.getInstance()) :
				new CMDBfDeregistrationOperation(SampleNotificationHandlerFactory.getInstance(), DeregisterOutputArtifactFactory.getInstance());
		operation.initialize(init);
		IResponse response = type == INotificationHandler.REGISTRATION ?
				((CMDBfRegistrationOperation)operation).execute(this.getClass().getClassLoader().getResourceAsStream(input)) :
				((CMDBfDeregistrationOperation)operation).execute(this.getClass().getClassLoader().getResourceAsStream(input));
		
		// Write the results to the console
		InputStream responseis = type == INotificationHandler.REGISTRATION ?
				RegistrationOutputTransformer.transform((IRegisterResponse)response) :
				DeregistrationOutputTransformer.transform((IDeregisterResponse)response);
		
		byte[] buffer = new byte[1024];
		while (responseis.available() > 0)
		{
			int read = responseis.read(buffer);
			System.out.print(new String(buffer, 0, read));
		}		
	}
}
