/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.common;

import org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.IItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRelationshipNotificationHandler;

/**
 * The notification handler factory for the sample that
 * exercises the CMDBf registration/deregistration service
 * 
 * @author Ali Mehregani
 */
public class SampleNotificationHandlerFactory extends AbstractNotificationHandlerFactory
{
	/**
	 * The instance of this factory
	 */
	private static SampleNotificationHandlerFactory instance;
	
	public static INotificationHandlerFactory getInstance()
	{
		if (instance == null)
		{
			instance = new SampleNotificationHandlerFactory();
		}
		
		return instance;
	}
	
	@Override
	protected IItemNotificationHandler createRegistrationItemHandler()
	{
		return new SampleItemNotificationHandler();
	}
	
	@Override
	protected IRelationshipNotificationHandler createRegistrationRelationshipHandler()
	{
		return new SampleRelationshipNotificationHandler();
	}
	
	@Override
	protected IItemNotificationHandler createDeregistrationItemHandler() 
	{
		return new SampleItemNotificationHandler();
	}
	
	@Override
	protected IRelationshipNotificationHandler createDeregistrationRelationshipHandler() 
	{
		return new SampleRelationshipNotificationHandler();
	}
	
	@Override
	protected boolean isCachingSupported()
	{	
		return false;
	}
}
