/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.deregistration;

import java.io.IOException;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.samples.cmdbf.services.common.AbstractServiceLauncher;

/**
 * The main class that exercises the deregistration service
 * APIs
 */
public class DeregistrationLauncher extends AbstractServiceLauncher
{
	public static void main(String[] args) throws IOException, CMDBfServiceException
	{
		DeregistrationLauncher dl = new DeregistrationLauncher();
		dl.executeOperation(
				INotificationHandler.DEREGISTRATION, 
				"deregistration-request.txt", 
				new String[][]{
					new String[]{"org.eclipse.cosmos.samples.cmdbf.XMLRepository", "01"},
					new String[]{"org.eclipse.cosmos.samples.cmdbf.XMLRepository", "staff01"},
					new String[]{"org.eclipse.cosmos.samples.cmdbf.XMLRepository", "ECM01"}
				});
	}
}
